/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.traits;

import com.helger.commons.lang.GenericReflection;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.commons.typeconvert.TypeConverterException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IConvertibleDirectTrait {
    @Nullable
    public Object getValue();

    @Nullable
    default public Class<?> getValueClass() {
        Object object = this.getValue();
        return object == null ? null : object.getClass();
    }

    default public boolean hasValue() {
        return this.getValue() != null;
    }

    default public boolean hasNoValue() {
        return this.getValue() == null;
    }

    @Nullable
    default public <T> T getCastedValue() throws ClassCastException {
        return (T)GenericReflection.uncheckedCast(this.getValue());
    }

    @Nullable
    default public <T> T getCastedValue(@Nullable T t) throws ClassCastException {
        Object object = this.getValue();
        return (T)(object == null ? t : GenericReflection.uncheckedCast(object));
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnull Class<T> clazz) throws ClassCastException {
        return clazz.cast(this.getValue());
    }

    @Nullable
    default public <T> T getCastedValue(@Nullable T t, @Nonnull Class<T> clazz) throws ClassCastException {
        Object object = this.getValue();
        return object == null ? t : clazz.cast(object);
    }

    @Nullable
    default public <T> T getConvertedValue(@Nonnull Class<T> clazz) {
        return TypeConverter.convertIfNecessary(this.getValue(), clazz);
    }

    @Nullable
    default public <T> T getConvertedValue(@Nullable T t, @Nonnull Class<T> clazz) {
        Object object = this.getValue();
        return object == null ? t : TypeConverter.convertIfNecessary(object, clazz);
    }

    default public boolean getAsBoolean() throws TypeConverterException {
        return TypeConverter.convertToBoolean(this.getValue());
    }

    default public boolean getAsBoolean(boolean bl) {
        return TypeConverter.convertToBoolean(this.getValue(), bl);
    }

    default public byte getAsByte() throws TypeConverterException {
        return TypeConverter.convertToByte(this.getValue());
    }

    default public byte getAsByte(byte by) {
        return TypeConverter.convertToByte(this.getValue(), by);
    }

    default public char getAsChar() throws TypeConverterException {
        return TypeConverter.convertToChar(this.getValue());
    }

    default public char getAsChar(char c) {
        return TypeConverter.convertToChar(this.getValue(), c);
    }

    default public double getAsDouble() throws TypeConverterException {
        return TypeConverter.convertToDouble(this.getValue());
    }

    default public double getAsDouble(double d) {
        return TypeConverter.convertToDouble(this.getValue(), d);
    }

    default public float getAsFloat() throws TypeConverterException {
        return TypeConverter.convertToFloat(this.getValue());
    }

    default public float getAsFloat(float f) {
        return TypeConverter.convertToFloat(this.getValue(), f);
    }

    default public int getAsInt() throws TypeConverterException {
        return TypeConverter.convertToInt(this.getValue());
    }

    default public int getAsInt(int n) {
        return TypeConverter.convertToInt(this.getValue(), n);
    }

    default public long getAsLong() throws TypeConverterException {
        return TypeConverter.convertToLong(this.getValue());
    }

    default public long getAsLong(long l) {
        return TypeConverter.convertToLong(this.getValue(), l);
    }

    default public short getAsShort() throws TypeConverterException {
        return TypeConverter.convertToShort(this.getValue());
    }

    default public short getAsShort(short s) {
        return TypeConverter.convertToShort(this.getValue(), s);
    }

    @Nullable
    default public String getAsString() throws TypeConverterException {
        return this.getConvertedValue(String.class);
    }

    @Nullable
    default public String getAsString(@Nullable String string) throws TypeConverterException {
        return this.getConvertedValue(string, String.class);
    }

    @Nullable
    default public char[] getAsCharArray() throws TypeConverterException {
        return this.getConvertedValue(char[].class);
    }

    @Nullable
    default public char[] getAsCharArray(@Nullable char[] cArray) throws TypeConverterException {
        return this.getConvertedValue(cArray, char[].class);
    }

    @Nullable
    default public BigDecimal getAsBigDecimal() throws TypeConverterException {
        return this.getConvertedValue(BigDecimal.class);
    }

    @Nullable
    default public BigDecimal getAsBigDecimal(@Nullable BigDecimal bigDecimal) throws TypeConverterException {
        return this.getConvertedValue(bigDecimal, BigDecimal.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger() throws TypeConverterException {
        return this.getConvertedValue(BigInteger.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger(@Nullable BigInteger bigInteger) throws TypeConverterException {
        return this.getConvertedValue(bigInteger, BigInteger.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate() throws TypeConverterException {
        return this.getConvertedValue(LocalDate.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate(@Nullable LocalDate localDate) throws TypeConverterException {
        return this.getConvertedValue(localDate, LocalDate.class);
    }

    @Nullable
    default public LocalTime getAsLocalTime() throws TypeConverterException {
        return this.getConvertedValue(LocalTime.class);
    }

    @Nullable
    default public LocalTime getAsLocalTime(@Nullable LocalTime localTime) throws TypeConverterException {
        return this.getConvertedValue(localTime, LocalTime.class);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime() throws TypeConverterException {
        return this.getConvertedValue(LocalDateTime.class);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime(@Nullable LocalDateTime localDateTime) throws TypeConverterException {
        return this.getConvertedValue(LocalDateTime.class);
    }

    @Nullable
    default public byte[] getAsByteArray() throws TypeConverterException {
        return this.getConvertedValue(byte[].class);
    }

    @Nullable
    default public Boolean getAsBooleanObj() throws TypeConverterException {
        return this.getConvertedValue(Boolean.class);
    }

    @Nullable
    default public Byte getAsByteObj() throws TypeConverterException {
        return this.getConvertedValue(Byte.class);
    }

    @Nullable
    default public Character getAsCharObj() throws TypeConverterException {
        return this.getConvertedValue(Character.class);
    }

    @Nullable
    default public Double getAsDoubleObj() {
        return this.getConvertedValue(Double.class);
    }

    @Nullable
    default public Float getAsFloatObj() throws TypeConverterException {
        return this.getConvertedValue(Float.class);
    }

    @Nullable
    default public Integer getAsIntObj() throws TypeConverterException {
        return this.getConvertedValue(Integer.class);
    }

    @Nullable
    default public Long getAsLongObj() throws TypeConverterException {
        return this.getConvertedValue(Long.class);
    }

    @Nullable
    default public Short getAsShortObj() throws TypeConverterException {
        return this.getConvertedValue(Short.class);
    }

    @Nullable
    default public Blob getAsSqlBlob() throws TypeConverterException {
        return this.getConvertedValue(Blob.class);
    }

    @Nullable
    default public Clob getAsSqlClob() throws TypeConverterException {
        return this.getConvertedValue(Clob.class);
    }

    @Nullable
    default public Date getAsSqlDate() throws TypeConverterException {
        return this.getConvertedValue(Date.class);
    }

    @Nullable
    default public NClob getAsSqlNClob() throws TypeConverterException {
        return this.getConvertedValue(NClob.class);
    }

    @Nullable
    default public RowId getAsSqlRowId() throws TypeConverterException {
        return this.getConvertedValue(RowId.class);
    }

    @Nullable
    default public Time getAsSqlTime() throws TypeConverterException {
        return this.getConvertedValue(Time.class);
    }

    @Nullable
    default public Timestamp getAsSqlTimestamp() throws TypeConverterException {
        return this.getConvertedValue(Timestamp.class);
    }

    @Nonnull
    public static IConvertibleDirectTrait wrap(@Nullable Object object) {
        return () -> object;
    }
}

