/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.IHasOutputStream;
import com.helger.commons.io.IHasReader;
import com.helger.commons.io.IHasWriter;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IResourceBase;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.commons.typeconvert.ITypeConverterRegistry;
import com.helger.commons.url.URLHelper;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@IsSPIImplementation
@Immutable
public final class IOTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverter(File.class, String.class, file -> file.getAbsolutePath());
        iTypeConverterRegistry.registerTypeConverter(File.class, URI.class, file -> file.toURI());
        iTypeConverterRegistry.registerTypeConverter(File.class, URL.class, file -> URLHelper.getAsURL(file.toURI()));
        iTypeConverterRegistry.registerTypeConverter(URI.class, File.class, uRI -> new File((URI)uRI));
        iTypeConverterRegistry.registerTypeConverter(URI.class, URL.class, uRI -> URLHelper.getAsURL(uRI));
        iTypeConverterRegistry.registerTypeConverter(URL.class, String.class, uRL -> uRL.toExternalForm());
        iTypeConverterRegistry.registerTypeConverter(URL.class, File.class, uRL -> {
            try {
                return new File(uRL.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException uRISyntaxException) {
                return new File(uRL.getPath());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URL.class, URI.class, uRL -> URLHelper.getAsURI(uRL));
        iTypeConverterRegistry.registerTypeConverter(String.class, File.class, string -> new File((String)string));
        iTypeConverterRegistry.registerTypeConverter(String.class, URI.class, string -> URLHelper.getAsURI(string));
        iTypeConverterRegistry.registerTypeConverter(String.class, URL.class, string -> URLHelper.getAsURL(string));
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IResourceBase.class, String.class, iResourceBase -> iResourceBase.getPath());
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IResourceBase.class, URL.class, iResourceBase -> iResourceBase.getAsURL());
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IResourceBase.class, File.class, iResourceBase -> iResourceBase.getAsFile());
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IHasInputStream.class, InputStream.class, iHasInputStream -> iHasInputStream.getInputStream());
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IHasOutputStream.class, OutputStream.class, iHasOutputStream -> iHasOutputStream.getOutputStream(EAppend.DEFAULT));
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IHasReader.class, Reader.class, iHasReader -> iHasReader.getReader());
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IHasWriter.class, Writer.class, iHasWriter -> iHasWriter.getWriter());
        iTypeConverterRegistry.registerTypeConverter(String.class, ClassPathResource.class, string -> new ClassPathResource((String)string));
        iTypeConverterRegistry.registerTypeConverter(URL.class, ClassPathResource.class, uRL -> new ClassPathResource((URL)uRL));
        iTypeConverterRegistry.registerTypeConverter(String.class, FileSystemResource.class, string -> new FileSystemResource((String)string));
        iTypeConverterRegistry.registerTypeConverter(URL.class, FileSystemResource.class, uRL -> {
            try {
                URI uRI = uRL.toURI();
                return new FileSystemResource(uRI);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return null;
        });
        iTypeConverterRegistry.registerTypeConverter(String.class, URLResource.class, string -> {
            try {
                return new URLResource((String)string);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URL.class, URLResource.class, uRL -> new URLResource((URL)uRL));
        iTypeConverterRegistry.registerTypeConverter(URI.class, URLResource.class, uRI -> {
            try {
                return new URLResource((URI)uRI);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        });
    }
}

