/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resourceprovider;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.resource.IWritableResource;
import com.helger.commons.io.resourceprovider.IReadableResourceProvider;
import com.helger.commons.io.resourceprovider.IWritableResourceProvider;
import com.helger.commons.io.resourceprovider.ReadableResourceProviderChain;
import com.helger.commons.string.ToStringGenerator;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WritableResourceProviderChain
extends ReadableResourceProviderChain
implements IWritableResourceProvider {
    protected final ICommonsList<IWritableResourceProvider> m_aWritableResourceProviders = new CommonsArrayList<IWritableResourceProvider>();

    public WritableResourceProviderChain(IReadableResourceProvider ... iReadableResourceProviderArray) {
        super(iReadableResourceProviderArray);
        for (IReadableResourceProvider iReadableResourceProvider : iReadableResourceProviderArray) {
            if (!(iReadableResourceProvider instanceof IWritableResourceProvider)) continue;
            this.m_aWritableResourceProviders.add((IWritableResourceProvider)iReadableResourceProvider);
        }
        if (this.m_aWritableResourceProviders.isEmpty()) {
            throw new IllegalArgumentException("No writable resource provider passed - use a ReadableResourceProviderChain");
        }
    }

    public WritableResourceProviderChain(@Nonnull Iterable<? extends IReadableResourceProvider> iterable) {
        super(iterable);
        for (IReadableResourceProvider iReadableResourceProvider : iterable) {
            if (!(iReadableResourceProvider instanceof IWritableResourceProvider)) continue;
            this.m_aWritableResourceProviders.add((IWritableResourceProvider)iReadableResourceProvider);
        }
        if (this.m_aWritableResourceProviders.isEmpty()) {
            throw new IllegalArgumentException("No writable resource provider passed - use a ReadableResourceProviderChain");
        }
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<IWritableResourceProvider> getAllContainedWritingResourceProviders() {
        return (ICommonsList)this.m_aWritableResourceProviders.getClone();
    }

    @Override
    public final boolean supportsWriting(@Nullable String string) {
        return this.m_aWritableResourceProviders.containsAny(iWritableResourceProvider -> iWritableResourceProvider.supportsWriting(string));
    }

    @Override
    @Nonnull
    @OverrideOnDemand
    public IWritableResource getWritableResource(@Nonnull String string) {
        for (IWritableResourceProvider iWritableResourceProvider : this.m_aWritableResourceProviders) {
            if (!iWritableResourceProvider.supportsWriting(string)) continue;
            return iWritableResourceProvider.getWritableResource(string);
        }
        throw new IllegalArgumentException("Cannot handle writing '" + string + "' by any of " + this.m_aReadingResourceProviders);
    }

    @Override
    @Nullable
    public OutputStream getOutputStream(@Nonnull String string, @Nonnull EAppend eAppend) {
        for (IWritableResourceProvider iWritableResourceProvider : this.m_aWritableResourceProviders) {
            OutputStream outputStream = iWritableResourceProvider.getOutputStream(string, eAppend);
            if (outputStream == null) continue;
            return outputStream;
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        WritableResourceProviderChain writableResourceProviderChain = (WritableResourceProviderChain)object;
        return this.m_aWritableResourceProviders.equals(writableResourceProviderChain.m_aWritableResourceProviders);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aWritableResourceProviders)).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("writableResProviders", this.m_aWritableResourceProviders).toString();
    }
}

