/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.cache;

import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.IsLocked;
import com.helger.commons.cache.AbstractCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractNotifyingCache<KEYTYPE, VALUETYPE>
extends AbstractCache<KEYTYPE, VALUETYPE> {
    public AbstractNotifyingCache(@Nonnull String string) {
        this(-1, string);
    }

    public AbstractNotifyingCache(@CheckForSigned int n, @Nonnull String string) {
        super(n, string);
    }

    @Nonnull
    @IsLocked(value=ELockType.WRITE)
    protected abstract VALUETYPE getValueToCache(KEYTYPE var1);

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public final VALUETYPE getFromCache(KEYTYPE KEYTYPE) {
        Object object = super.getFromCacheNoStats(KEYTYPE);
        if (object == null) {
            object = this.m_aRWLock.writeLocked(() -> {
                Object VALUETYPE = super.getFromCacheNoStatsNotLocked(KEYTYPE);
                if (VALUETYPE == null) {
                    VALUETYPE = this.getValueToCache(KEYTYPE);
                    if (VALUETYPE == null) {
                        throw new IllegalStateException("The value to cache was null for key '" + KEYTYPE + "'");
                    }
                    super.putInCacheNotLocked(KEYTYPE, VALUETYPE);
                    this.m_aCacheAccessStats.cacheMiss();
                } else {
                    this.m_aCacheAccessStats.cacheHit();
                }
                return VALUETYPE;
            });
        } else {
            this.m_aCacheAccessStats.cacheHit();
        }
        return object;
    }
}

