/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.collection.ext.CommonsVector;
import com.helger.commons.factory.IFactory;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SafeVector<ELEMENTTYPE>
extends CommonsVector<ELEMENTTYPE> {
    @MustImplementEqualsAndHashcode
    private final IFactory<ELEMENTTYPE> m_aFactory;

    public SafeVector() {
        this(() -> null);
    }

    public SafeVector(@Nonnull IFactory<ELEMENTTYPE> iFactory) {
        this.m_aFactory = ValueEnforcer.notNull(iFactory, "Factory");
    }

    @Nonnull
    public IFactory<ELEMENTTYPE> getFactory() {
        return this.m_aFactory;
    }

    private void _ensureSize(@Nonnegative int n) {
        int n2 = n - this.size() + 1;
        for (int i = 0; i < n2; ++i) {
            this.add(this.m_aFactory.get());
        }
    }

    @Override
    public synchronized ELEMENTTYPE get(@Nonnegative int n) {
        this._ensureSize(n);
        return (ELEMENTTYPE)super.get(n);
    }

    @Nullable
    public synchronized ELEMENTTYPE computeIfAbsent(@Nonnegative int n, @Nonnull Supplier<? extends ELEMENTTYPE> supplier) {
        this._ensureSize(n);
        Object object = super.get(n);
        if (object == null) {
            object = supplier.get();
            super.set(n, object);
        }
        return (ELEMENTTYPE)object;
    }

    @Override
    public synchronized ELEMENTTYPE set(@Nonnegative int n, @Nonnull ELEMENTTYPE ELEMENTTYPE) {
        this._ensureSize(n);
        return super.set(n, ELEMENTTYPE);
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SafeVector safeVector = (SafeVector)object;
        return this.m_aFactory.equals(safeVector.m_aFactory);
    }

    @Override
    public synchronized int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFactory).getHashCode();
    }

    @Override
    public synchronized String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("factory", this.m_aFactory).toString();
    }
}

