/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.IError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.location.ErrorLocation;
import com.helger.commons.error.location.IErrorLocation;
import com.helger.commons.error.text.ConstantHasErrorText;
import com.helger.commons.error.text.DynamicHasErrorText;
import com.helger.commons.error.text.IHasErrorText;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.traits.IGenericImplTrait;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SingleError
implements IError {
    private final IErrorLevel m_aErrorLevel;
    private final String m_sErrorID;
    private final String m_sErrorFieldName;
    private final IErrorLocation m_aErrorLocation;
    private final IHasErrorText m_aErrorText;
    private final Throwable m_aLinkedException;

    public SingleError(@Nonnull IErrorLevel iErrorLevel, @Nullable String string, @Nullable String string2, @Nullable IErrorLocation iErrorLocation, @Nullable IHasErrorText iHasErrorText, @Nullable Throwable throwable) {
        this.m_aErrorLevel = ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        this.m_sErrorID = string;
        this.m_sErrorFieldName = string2;
        this.m_aErrorLocation = iErrorLocation != null ? iErrorLocation : ErrorLocation.NO_LOCATION;
        this.m_aErrorText = iHasErrorText;
        this.m_aLinkedException = throwable;
    }

    @Override
    @Nonnull
    public IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Override
    @Nullable
    public String getErrorID() {
        return this.m_sErrorID;
    }

    @Override
    @Nullable
    public String getErrorFieldName() {
        return this.m_sErrorFieldName;
    }

    @Override
    @Nonnull
    public IErrorLocation getErrorLocation() {
        return this.m_aErrorLocation;
    }

    @Override
    @Nullable
    public IHasErrorText getErrorTexts() {
        return this.m_aErrorText;
    }

    @Override
    @Nullable
    public Throwable getLinkedException() {
        return this.m_aLinkedException;
    }

    @OverrideOnDemand
    protected boolean equalsLinkedException(@Nullable Throwable throwable, @Nullable Throwable throwable2) {
        if (EqualsHelper.identityEqual(throwable, throwable2)) {
            return true;
        }
        if (throwable == null || throwable2 == null) {
            return false;
        }
        return throwable.getClass().equals(throwable2.getClass()) && EqualsHelper.equals(throwable.getMessage(), throwable2.getMessage());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleError singleError = (SingleError)object;
        return this.m_aErrorLevel.equals(singleError.m_aErrorLevel) && EqualsHelper.equals(this.m_sErrorID, singleError.m_sErrorID) && EqualsHelper.equals(this.m_sErrorFieldName, singleError.m_sErrorFieldName) && EqualsHelper.equals(this.m_aErrorLocation, singleError.m_aErrorLocation) && EqualsHelper.equals(this.m_aErrorText, singleError.m_aErrorText) && this.equalsLinkedException(this.m_aLinkedException, singleError.m_aLinkedException);
    }

    @OverrideOnDemand
    protected void hashCodeLinkedException(@Nonnull HashCodeGenerator hashCodeGenerator, @Nullable Throwable throwable) {
        if (throwable == null) {
            hashCodeGenerator.append(throwable);
        } else {
            hashCodeGenerator.append(throwable.getClass()).append(throwable.getMessage());
        }
    }

    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this).append(this.m_aErrorLevel).append(this.m_sErrorID).append(this.m_sErrorFieldName).append(this.m_aErrorLocation).append(this.m_aErrorText);
        this.hashCodeLinkedException(hashCodeGenerator, this.m_aLinkedException);
        return hashCodeGenerator.getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ErrorLevel", this.m_aErrorLevel).appendIfNotNull("ErrorID", this.m_sErrorID).appendIfNotNull("ErrorFieldName", this.m_sErrorFieldName).appendIfNotNull("ErrorLocation", this.m_aErrorLocation).appendIfNotNull("ErrorText", this.m_aErrorText).appendIfNotNull("LinkedException", this.m_aLinkedException).toString();
    }

    @Nonnull
    public static SingleErrorBuilder builder() {
        return new SingleErrorBuilder();
    }

    @Nonnull
    public static SingleErrorBuilder builder(@Nonnull IError iError) {
        return new SingleErrorBuilder(iError);
    }

    @Nonnull
    public static SingleErrorBuilder builderSuccess() {
        return (SingleErrorBuilder)SingleError.builder().setErrorLevel(EErrorLevel.SUCCESS);
    }

    @Nonnull
    public static SingleErrorBuilder builderInfo() {
        return (SingleErrorBuilder)SingleError.builder().setErrorLevel(EErrorLevel.INFO);
    }

    @Nonnull
    public static SingleErrorBuilder builderWarn() {
        return (SingleErrorBuilder)SingleError.builder().setErrorLevel(EErrorLevel.WARN);
    }

    @Nonnull
    public static SingleErrorBuilder builderError() {
        return (SingleErrorBuilder)SingleError.builder().setErrorLevel(EErrorLevel.ERROR);
    }

    @Nonnull
    public static SingleErrorBuilder builderFatalError() {
        return (SingleErrorBuilder)SingleError.builder().setErrorLevel(EErrorLevel.FATAL_ERROR);
    }

    public static final class SingleErrorBuilder
    extends AbstractBuilder<SingleError, SingleErrorBuilder> {
        public SingleErrorBuilder() {
        }

        public SingleErrorBuilder(@Nonnull IError iError) {
            super(iError);
        }

        @Override
        @Nonnull
        public SingleError build() {
            return new SingleError(this.m_aErrorLevel, this.m_sErrorID, this.m_sErrorFieldName, this.m_aErrorLocation, this.m_aErrorText, this.m_aLinkedException);
        }
    }

    public static abstract class AbstractBuilder<T extends SingleError, IMPLTYPE extends AbstractBuilder<T, IMPLTYPE>>
    implements IGenericImplTrait<IMPLTYPE> {
        public static final IErrorLevel DEFAULT_ERROR_LEVEL = EErrorLevel.ERROR;
        protected IErrorLevel m_aErrorLevel = DEFAULT_ERROR_LEVEL;
        protected String m_sErrorID;
        protected String m_sErrorFieldName;
        protected IErrorLocation m_aErrorLocation;
        protected IHasErrorText m_aErrorText;
        protected Throwable m_aLinkedException;

        public AbstractBuilder() {
        }

        public AbstractBuilder(@Nonnull IError iError) {
            ValueEnforcer.notNull(iError, "Error");
            this.setErrorLevel(iError.getErrorLevel());
            this.setErrorID(iError.getErrorID());
            this.setErrorFieldName(iError.getErrorFieldName());
            this.setErrorLocation(iError.getErrorLocation());
            this.setErrorText(iError.getErrorTexts());
            this.setLinkedException(iError.getLinkedException());
        }

        @Nonnull
        public IMPLTYPE setErrorLevel(@Nonnull IErrorLevel iErrorLevel) {
            ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
            this.m_aErrorLevel = iErrorLevel;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public IMPLTYPE setErrorID(@Nullable String string) {
            this.m_sErrorID = string;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public IMPLTYPE setErrorFieldName(@Nullable String string) {
            this.m_sErrorFieldName = string;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public IMPLTYPE setErrorLocation(@Nullable IErrorLocation iErrorLocation) {
            this.m_aErrorLocation = iErrorLocation;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public IMPLTYPE setErrorText(@Nullable String string) {
            return this.setErrorText(ConstantHasErrorText.createOnDemand(string));
        }

        @Nonnull
        public IMPLTYPE setErrorText(@Nullable IMultilingualText iMultilingualText) {
            this.m_aErrorText = iMultilingualText == null ? null : (iMultilingualText.getSize() == 1 ? ConstantHasErrorText.createOnDemand(iMultilingualText.getAllTexts().getFirstValue()) : new DynamicHasErrorText((IHasText)iMultilingualText));
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public IMPLTYPE setErrorText(@Nullable IHasErrorText iHasErrorText) {
            this.m_aErrorText = iHasErrorText;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public IMPLTYPE setLinkedException(@Nullable Throwable throwable) {
            this.m_aLinkedException = throwable;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public abstract T build();
    }
}

