/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.scope.AbstractMapBasedScope;
import com.helger.commons.scope.IApplicationScope;
import com.helger.commons.scope.IGlobalScope;
import com.helger.commons.scope.ScopeHelper;
import com.helger.commons.scope.mgr.MetaScopeFactory;
import com.helger.commons.scope.spi.ScopeSPIManager;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GlobalScope
extends AbstractMapBasedScope
implements IGlobalScope {
    private static final Logger s_aLogger = LoggerFactory.getLogger(GlobalScope.class);
    private final ICommonsMap<String, IApplicationScope> m_aAppScopes = new CommonsHashMap<String, IApplicationScope>();

    public GlobalScope(@Nonnull @Nonempty String string) {
        super(string);
        if (ScopeHelper.debugGlobalScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Created global scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    public void initScope() {
    }

    @Override
    protected void destroyOwnedScopes() {
        this.m_aRWLock.writeLocked(() -> {
            for (IApplicationScope iApplicationScope : this.m_aAppScopes.values()) {
                ScopeSPIManager.getInstance().onApplicationScopeEnd(iApplicationScope);
                iApplicationScope.destroyScope();
            }
            this.m_aAppScopes.clear();
        });
    }

    @Override
    protected void preDestroy() {
        if (ScopeHelper.debugGlobalScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroying global scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeHelper.debugGlobalScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroyed global scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Nonnull
    @OverrideOnDemand
    protected IApplicationScope createApplicationScope(@Nonnull @Nonempty String string) {
        return MetaScopeFactory.getScopeFactory().createApplicationScope(string);
    }

    @Override
    @Nullable
    public IApplicationScope getApplicationScope(@Nonnull @Nonempty String string, boolean bl) {
        ValueEnforcer.notEmpty(string, "ApplicationID");
        IApplicationScope iApplicationScope = this.m_aRWLock.readLocked(() -> (IApplicationScope)this.m_aAppScopes.get(string));
        if (iApplicationScope == null && bl) {
            iApplicationScope = this.m_aRWLock.writeLocked(() -> {
                IApplicationScope iApplicationScope = (IApplicationScope)this.m_aAppScopes.get(string);
                if (iApplicationScope == null) {
                    iApplicationScope = this.createApplicationScope(string);
                    this.m_aAppScopes.put(string, iApplicationScope);
                    iApplicationScope.initScope();
                    ScopeSPIManager.getInstance().onApplicationScopeBegin(iApplicationScope);
                }
                return iApplicationScope;
            });
        }
        return iApplicationScope;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, IApplicationScope> getAllApplicationScopes() {
        return this.m_aRWLock.readLocked(() -> (ICommonsMap)this.m_aAppScopes.getClone());
    }

    @Override
    @Nonnegative
    public int getApplicationScopeCount() {
        return this.m_aRWLock.readLocked(() -> this.m_aAppScopes.size());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        GlobalScope globalScope = (GlobalScope)object;
        return this.m_aAppScopes.equals(globalScope.m_aAppScopes);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aAppScopes)).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("appScopes", this.m_aAppScopes).toString();
    }
}

