/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert.rule;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.typeconvert.ITypeConverterRule;
import com.helger.commons.typeconvert.rule.AbstractTypeConverterRule;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TypeConverterRuleAnySourceFixedDestination<DST>
extends AbstractTypeConverterRule<Object, DST> {
    private final Class<DST> m_aDstClass;
    private final Function<Object, DST> m_aConverter;

    public TypeConverterRuleAnySourceFixedDestination(@Nonnull Class<DST> clazz, @Nonnull Function<Object, DST> function) {
        super(ITypeConverterRule.ESubType.ANY_SRC_FIXED_DST);
        this.m_aDstClass = ValueEnforcer.notNull(clazz, "DestClass");
        this.m_aConverter = ValueEnforcer.notNull(function, "Converter");
    }

    @Override
    public final boolean canConvert(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        return this.m_aDstClass.equals(clazz2);
    }

    @Nonnull
    public final Class<?> getDestinationClass() {
        return this.m_aDstClass;
    }

    @Override
    @Nullable
    public DST apply(@Nonnull Object object) {
        return this.m_aConverter.apply(object);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("dstClass", this.m_aDstClass.getName()).append("converter", this.m_aConverter).toString();
    }
}

