/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsCollection;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.IURLData;
import com.helger.commons.url.URLData;
import com.helger.commons.url.URLHelper;
import com.helger.commons.url.URLParameter;
import com.helger.commons.url.URLParameterDecoder;
import com.helger.commons.url.URLParameterList;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SimpleURL
implements ISimpleURL,
ICloneable<SimpleURL> {
    private final String m_sPath;
    private final URLParameterList m_aParams = new URLParameterList();
    private String m_sAnchor;

    public SimpleURL() {
        this(URLData.EMPTY_URL_DATA);
    }

    public SimpleURL(@Nonnull URL uRL) {
        this(uRL, URLHelper.CHARSET_URL_OBJ);
    }

    public SimpleURL(@Nonnull URL uRL, @Nonnull Charset charset) {
        this(uRL.toExternalForm(), charset);
    }

    public SimpleURL(@Nonnull String string) {
        this(string, URLHelper.CHARSET_URL_OBJ);
    }

    public SimpleURL(@Nonnull String string, @Nonnull Charset charset) {
        this(URLHelper.getAsURLData(string, new URLParameterDecoder(charset)));
    }

    public SimpleURL(@Nonnull String string, @Nullable Map<String, String> map) {
        this(string);
        this.addAll(map);
    }

    public SimpleURL(@Nonnull String string, @Nullable Map<String, String> map, @Nullable String string2) {
        this(string, URLHelper.CHARSET_URL_OBJ, map, string2);
    }

    public SimpleURL(@Nonnull String string, @Nonnull Charset charset, @Nullable Map<String, String> map, @Nullable String string2) {
        this(string, charset);
        this.addAll(map);
        this.m_sAnchor = string2;
    }

    public SimpleURL(@Nonnull String string, @Nullable Iterable<? extends URLParameter> iterable, @Nullable String string2) {
        this(string, URLHelper.CHARSET_URL_OBJ, iterable, string2);
    }

    public SimpleURL(@Nonnull String string, @Nonnull Charset charset, @Nullable Iterable<? extends URLParameter> iterable, @Nullable String string2) {
        this(string, charset);
        this.addAll(iterable);
        this.m_sAnchor = string2;
    }

    public SimpleURL(@Nonnull IURLData iURLData) {
        ValueEnforcer.notNull(iURLData, "URL");
        this.m_sPath = iURLData.getPath();
        if (iURLData.hasParams()) {
            this.m_aParams.addAll(iURLData.directGetAllParams());
        }
        this.m_sAnchor = iURLData.getAnchor();
    }

    @Override
    @Nonnull
    public final String getPath() {
        return this.m_sPath;
    }

    @Override
    public final boolean hasParams() {
        return this.m_aParams.isNotEmpty();
    }

    @Override
    @Nonnegative
    public final int getParamCount() {
        return this.m_aParams.size();
    }

    @Override
    public final boolean containsParam(@Nullable String string) {
        return this.getParam(string) != null;
    }

    @Override
    @Nullable
    public final String getParam(@Nullable String string) {
        for (URLParameter uRLParameter : this.m_aParams) {
            if (!uRLParameter.hasName(string)) continue;
            return uRLParameter.getValue();
        }
        return null;
    }

    @Override
    @Nullable
    public final ICommonsList<String> getAllParams(@Nullable String string) {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        for (URLParameter uRLParameter : this.m_aParams) {
            if (!uRLParameter.hasName(string)) continue;
            commonsArrayList.add(uRLParameter.getValue());
        }
        return commonsArrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject(value="design")
    public final URLParameterList directGetAllParams() {
        return this.m_aParams;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final URLParameterList getAllParams() {
        return this.m_aParams.getClone();
    }

    @Nonnull
    public final SimpleURL add(@Nonnull @Nonempty String string) {
        return this.add(string, "");
    }

    @Nonnull
    public final SimpleURL add(@Nonnull Map.Entry<String, String> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    @Nonnull
    public final SimpleURL add(@Nonnull @Nonempty String string, @Nullable String string2) {
        String string3 = string2 != null ? string2 : "";
        return this.add(new URLParameter(string, string3));
    }

    @Nonnull
    public final SimpleURL add(@Nonnull URLParameter uRLParameter) {
        ValueEnforcer.notNull(uRLParameter, "Param");
        this.m_aParams.add(uRLParameter);
        return this;
    }

    @Nonnull
    public final SimpleURL add(@Nonnull @Nonempty String string, boolean bl) {
        return this.add(string, Boolean.toString(bl));
    }

    @Nonnull
    public final SimpleURL add(@Nonnull @Nonempty String string, int n) {
        return this.add(string, Integer.toString(n));
    }

    @Nonnull
    public final SimpleURL add(@Nonnull @Nonempty String string, long l) {
        return this.add(string, Long.toString(l));
    }

    @Nonnull
    public final SimpleURL add(@Nonnull @Nonempty String string, @Nullable BigInteger bigInteger) {
        return this.add(string, bigInteger != null ? bigInteger.toString() : null);
    }

    @Nonnull
    public final SimpleURL addIfNotNull(@Nonnull @Nonempty String string, @Nullable String string2) {
        if (string2 != null) {
            this.add(string, string2);
        }
        return this;
    }

    @Nonnull
    public final SimpleURL addIf(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull Predicate<String> predicate) {
        if (predicate.test(string2)) {
            this.add(string, string2);
        }
        return this;
    }

    @Nonnull
    public final SimpleURL addAll(@Nullable Map<String, String> map) {
        if (CollectionHelper.isNotEmpty(map)) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Nonnull
    public final SimpleURL addAll(@Nullable Iterable<? extends URLParameter> iterable) {
        if (CollectionHelper.isNotEmpty(iterable)) {
            for (URLParameter uRLParameter : iterable) {
                this.add(uRLParameter);
            }
        }
        return this;
    }

    @Nonnull
    public SimpleURL remove(@Nullable String string) {
        this.m_aParams.remove(string);
        return this;
    }

    @Nonnull
    public SimpleURL remove(@Nullable String string, @Nullable String string2) {
        this.m_aParams.remove(string, string2);
        return this;
    }

    @Override
    @Nullable
    public final String getAnchor() {
        return this.m_sAnchor;
    }

    @Nonnull
    public SimpleURL setAnchor(@Nullable String string) {
        this.m_sAnchor = string;
        return this;
    }

    @Override
    @Nonnull
    public SimpleURL getClone() {
        return new SimpleURL(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SimpleURL simpleURL = (SimpleURL)object;
        return this.m_sPath.equals(simpleURL.m_sPath) && this.m_aParams.equals(simpleURL.m_aParams) && EqualsHelper.equals(this.m_sAnchor, simpleURL.m_sAnchor);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sPath).append((Iterable)this.m_aParams)).append(this.m_sAnchor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("path", this.m_sPath).appendIf("params", this.m_aParams, ICommonsCollection::isNotEmpty).appendIfNotNull("anchor", this.m_sAnchor).toString();
    }
}

