/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.codec.IEncoder;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class URLParameter {
    private final String m_sName;
    private final String m_sValue;
    private transient int m_nHashCode = 0;

    public URLParameter(@Nonnull @Nonempty String string) {
        this(string, "");
    }

    public URLParameter(@Nonnull @Nonempty String string, @Nonnull String string2) {
        this.m_sName = ValueEnforcer.notEmpty(string, "Name");
        this.m_sValue = ValueEnforcer.notNull(string2, "Value");
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    public boolean hasName(@Nullable String string) {
        return this.m_sName.equals(string);
    }

    @Nonnull
    public String getValue() {
        return this.m_sValue;
    }

    public boolean hasValue() {
        return !this.m_sValue.isEmpty();
    }

    public boolean hasValue(@Nullable String string) {
        return this.m_sValue.equals(string);
    }

    public void appendTo(@Nonnull StringBuilder stringBuilder, @Nullable IEncoder<String, String> iEncoder) {
        if (iEncoder != null) {
            stringBuilder.append(iEncoder.getEncoded(this.m_sName));
        } else {
            stringBuilder.append(this.m_sName);
        }
        if (this.hasValue()) {
            stringBuilder.append('=');
            if (iEncoder != null) {
                stringBuilder.append(iEncoder.getEncoded(this.m_sValue));
            } else {
                stringBuilder.append(this.m_sValue);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        URLParameter uRLParameter = (URLParameter)object;
        return this.m_sName.equals(uRLParameter.m_sName) && this.m_sValue.equals(uRLParameter.m_sValue);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator(this).append(this.m_sName).append(this.m_sValue).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(null).append("name", this.m_sName).append("value", this.m_sValue).toString();
    }
}

