/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.codec.IByteArrayDecoder;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

@FunctionalInterface
public interface IByteArrayStreamDecoder
extends IByteArrayDecoder {
    public void decode(@Nullable byte[] var1, @Nonnegative int var2, @Nonnegative int var3, @Nonnull @WillNotClose OutputStream var4);

    @Override
    @Nullable
    @ReturnsMutableCopy
    default public byte[] getDecoded(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (byArray == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(this.getDecodedLength(n2));){
            this.decode(byArray, n, n2, nonBlockingByteArrayOutputStream);
            byte[] byArray2 = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    @Nullable
    default public String getDecodedAsString(@Nullable byte[] byArray, @Nonnull Charset charset) {
        if (byArray == null) {
            return null;
        }
        return this.getDecodedAsString(byArray, 0, byArray.length, charset);
    }

    @Nullable
    default public String getDecodedAsString(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        if (byArray == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(this.getDecodedLength(n2));){
            this.decode(byArray, n, n2, nonBlockingByteArrayOutputStream);
            String string = nonBlockingByteArrayOutputStream.getAsString(charset);
            return string;
        }
    }

    @Nullable
    default public String getDecodedAsString(@Nullable String string, @Nonnull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = CharsetManager.getAsBytes(string, charset);
        return this.getDecodedAsString(byArray, 0, byArray.length, charset);
    }
}

