/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.error.IError;
import com.helger.commons.error.IResourceError;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.location.IErrorLocation;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.display.ConstantHasDisplayText;
import com.helger.commons.text.display.IHasDisplayText;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Deprecated
@Immutable
public class ResourceError
implements IResourceError {
    private final IErrorLocation m_aLocation;
    private final IErrorLevel m_aErrorLevel;
    private final IHasDisplayText m_aErrorText;
    private final Throwable m_aLinkedException;

    public ResourceError(@Nonnull IErrorLocation iErrorLocation, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string) {
        this(iErrorLocation, iErrorLevel, string, null);
    }

    public ResourceError(@Nonnull IErrorLocation iErrorLocation, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        this(iErrorLocation, iErrorLevel, new ConstantHasDisplayText(string), throwable);
    }

    public ResourceError(@Nonnull IErrorLocation iErrorLocation, @Nonnull IErrorLevel iErrorLevel, @Nonnull IHasDisplayText iHasDisplayText) {
        this(iErrorLocation, iErrorLevel, iHasDisplayText, null);
    }

    public ResourceError(@Nonnull IErrorLocation iErrorLocation, @Nonnull IErrorLevel iErrorLevel, @Nonnull IHasDisplayText iHasDisplayText, @Nullable Throwable throwable) {
        this.m_aLocation = ValueEnforcer.notNull(iErrorLocation, "Location");
        this.m_aErrorLevel = ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        this.m_aErrorText = ValueEnforcer.notNull(iHasDisplayText, "ErrorText");
        this.m_aLinkedException = throwable;
    }

    @Override
    @Nonnull
    public final IErrorLocation getErrorLocation() {
        return this.m_aLocation;
    }

    @Override
    @Nonnull
    public final IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public String getDisplayText(@Nonnull Locale locale) {
        return this.getErrorText(locale);
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public String getErrorText(@Nonnull Locale locale) {
        return this.m_aErrorText.getDisplayText(locale);
    }

    @Override
    @Nullable
    public final Throwable getLinkedException() {
        return this.m_aLinkedException;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ResourceError resourceError = (ResourceError)object;
        return this.m_aLocation.equals(resourceError.m_aLocation) && this.m_aErrorLevel.equals(resourceError.m_aErrorLevel) && this.m_aErrorText.equals(resourceError.m_aErrorText);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aLocation).append(this.m_aErrorLevel).append(this.m_aErrorText).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("location", this.m_aLocation).append("errorLevel", this.m_aErrorLevel).append("errorText", this.m_aErrorText).appendIfNotNull("linkedException", this.m_aLinkedException).toString();
    }

    @Nonnull
    public static IResourceError createAndConvert(@Nonnull IError iError) {
        return new ResourceError(iError.getErrorLocation(), iError.getErrorLevel(), locale -> iError.getErrorText(locale), iError.getLinkedException());
    }
}

