/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error.list;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ErrorList
implements IErrorList,
ICloneable<ErrorList> {
    private final ICommonsList<IError> m_aList;

    public ErrorList() {
        this.m_aList = new CommonsArrayList<IError>();
    }

    public ErrorList(@Nullable Iterable<? extends IError> iterable) {
        this.m_aList = iterable == null ? new CommonsArrayList<IError>() : new CommonsArrayList<Iterable<? extends IError>>(iterable);
    }

    public ErrorList(IError ... iErrorArray) {
        this.m_aList = iErrorArray == null ? new CommonsArrayList<IError>() : new CommonsArrayList<IError>(iErrorArray);
    }

    public ErrorList(@Nonnull ErrorList errorList) {
        this.m_aList = errorList == null ? new CommonsArrayList() : (ICommonsList)errorList.m_aList.getClone();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aList.isEmpty();
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.m_aList.size();
    }

    @Override
    @Nonnull
    public Iterator<IError> iterator() {
        return this.m_aList.iterator();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IError> getAllItems() {
        return (ICommonsList)this.m_aList.getClone();
    }

    @Override
    @Nonnull
    public ErrorList getSubList(@Nullable Predicate<? super IError> predicate) {
        if (predicate == null) {
            return this.getClone();
        }
        ErrorList errorList = new ErrorList();
        this.m_aList.findAll(predicate, errorList.m_aList::add);
        return errorList;
    }

    @Nonnull
    public ErrorList add(@Nonnull IError iError) {
        ValueEnforcer.notNull(iError, "Error");
        this.m_aList.add(iError);
        return this;
    }

    public void addAll(@Nullable Iterable<? extends IError> iterable) {
        if (iterable != null) {
            for (IError iError : iterable) {
                this.add(iError);
            }
        }
    }

    public void addAll(IError ... iErrorArray) {
        if (iErrorArray != null) {
            for (IError iError : iErrorArray) {
                this.add(iError);
            }
        }
    }

    @Nonnull
    public EChange remove(@Nullable IError iError) {
        if (iError == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aList.removeObject(iError);
    }

    @Nonnull
    public EChange removeAll(@Nullable Iterable<? extends IError> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (IError iError : iterable) {
                eChange = eChange.or(this.remove(iError));
            }
        }
        return eChange;
    }

    @Nonnull
    public EChange removeAll(IError ... iErrorArray) {
        EChange eChange = EChange.UNCHANGED;
        if (iErrorArray != null) {
            for (IError iError : iErrorArray) {
                eChange = eChange.or(this.remove(iError));
            }
        }
        return eChange;
    }

    @Nonnull
    public EChange removeIf(@Nonnull Predicate<? super IError> predicate) {
        return EChange.valueOf(this.m_aList.removeIf(predicate));
    }

    @Nonnull
    public EChange clear() {
        return this.m_aList.removeAll();
    }

    @Override
    @Nonnull
    public ErrorList getClone() {
        return new ErrorList(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ErrorList errorList = (ErrorList)object;
        return this.m_aList.equals(errorList.m_aList);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aList)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("List", this.m_aList).toString();
    }
}

