/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.attr.MapBasedAttributeContainerAny;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsConcurrentHashMap;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.scope.IScope;
import com.helger.commons.scope.IScopeDestructionAware;
import com.helger.commons.scope.IScopeRenewalAware;
import com.helger.commons.string.ToStringGenerator;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractMapBasedScope
extends MapBasedAttributeContainerAny<String>
implements IScope {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractMapBasedScope.class);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final String m_sScopeID;
    private boolean m_bInPreDestruction = false;
    private boolean m_bInDestruction = false;
    private boolean m_bDestroyed = false;

    public AbstractMapBasedScope(@Nonnull @Nonempty String string) {
        super(true, new CommonsConcurrentHashMap());
        this.m_sScopeID = ValueEnforcer.notEmpty(string, "ScopeID");
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sScopeID;
    }

    @Override
    public final boolean isValid() {
        return this.m_aRWLock.readLocked(() -> !this.m_bInPreDestruction && !this.m_bInDestruction && !this.m_bDestroyed);
    }

    public final boolean isInPreDestruction() {
        return this.m_aRWLock.readLocked(() -> this.m_bInPreDestruction);
    }

    @Override
    public final boolean isInDestruction() {
        return this.m_aRWLock.readLocked(() -> this.m_bInDestruction);
    }

    @Override
    public final boolean isDestroyed() {
        return this.m_aRWLock.readLocked(() -> this.m_bDestroyed);
    }

    @OverrideOnDemand
    protected void preDestroy() {
    }

    @OverrideOnDemand
    protected void destroyOwnedScopes() {
    }

    @OverrideOnDemand
    protected void postDestroy() {
    }

    @Override
    public final void destroyScope() {
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_bInPreDestruction) {
                throw new IllegalStateException("Scope " + this.getID() + " is already in pre destruction!");
            }
            this.m_bInPreDestruction = true;
        });
        this.preDestroy();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.forAllAttributeValues(object -> {
            if (object instanceof IScopeDestructionAware) {
                commonsArrayList.add((IScopeDestructionAware)object);
            }
        });
        for (IScopeDestructionAware iScopeDestructionAware : commonsArrayList) {
            try {
                iScopeDestructionAware.onBeforeScopeDestruction(this);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to call onBeforeScopeDestruction in scope " + this.getID() + " for " + iScopeDestructionAware, throwable);
            }
        }
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_bDestroyed) {
                throw new IllegalStateException("Scope " + this.getID() + " is already destroyed!");
            }
            if (this.m_bInDestruction) {
                throw new IllegalStateException("Scope " + this.getID() + " is already in destruction!");
            }
            this.m_bInDestruction = true;
            this.m_bInPreDestruction = false;
        });
        this.destroyOwnedScopes();
        for (IScopeDestructionAware iScopeDestructionAware : commonsArrayList) {
            try {
                iScopeDestructionAware.onScopeDestruction(this);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to call onScopeDestruction in scope " + this.getID() + " for " + iScopeDestructionAware, throwable);
            }
        }
        this.m_aRWLock.writeLocked(() -> {
            this.clear();
            this.m_bDestroyed = true;
            this.m_bInDestruction = false;
        });
        this.postDestroy();
    }

    @Override
    public final void runAtomic(@Nonnull Consumer<IScope> consumer) {
        ValueEnforcer.notNull(consumer, "Consumer");
        this.m_aRWLock.writeLocked(() -> consumer.accept(this));
    }

    @Override
    @Nullable
    public final <T> T runAtomic(@Nonnull Function<IScope, T> function) {
        ValueEnforcer.notNull(function, "Function");
        return (T)this.m_aRWLock.writeLocked(() -> function.apply(this));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsMap<String, IScopeRenewalAware> getAllScopeRenewalAwareAttributes() {
        CommonsHashMap<String, IScopeRenewalAware> commonsHashMap = new CommonsHashMap<String, IScopeRenewalAware>();
        this.forAllAttributes((string, object) -> {
            if (object instanceof IScopeRenewalAware) {
                commonsHashMap.put(string, (IScopeRenewalAware)object);
            }
        });
        return commonsHashMap;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractMapBasedScope abstractMapBasedScope = (AbstractMapBasedScope)object;
        return this.m_sScopeID.equals(abstractMapBasedScope.m_sScopeID);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sScopeID).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("ScopeID", this.m_sScopeID).append("InDestruction", this.m_bInDestruction).append("Destroyed", this.m_bDestroyed).toString();
    }
}

