/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.codec.IDecoder;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IByteArrayDecoder
extends IDecoder<byte[], byte[]> {
    @Nonnegative
    default public int getDecodedLength(@Nonnegative int n) {
        return n;
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    default public byte[] getDecoded(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return this.getDecoded(byArray, 0, byArray.length);
    }

    @Nullable
    @ReturnsMutableCopy
    public byte[] getDecoded(@Nullable byte[] var1, @Nonnegative int var2, @Nonnegative int var3);

    @Nullable
    @ReturnsMutableCopy
    default public byte[] getDecoded(@Nullable String string, @Nonnull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = CharsetManager.getAsBytes(string, charset);
        return this.getDecoded(byArray);
    }
}

