/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mutable;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mutable.AbstractMutableInteger;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MutableInt
extends AbstractMutableInteger<MutableInt> {
    public static final int DEFAULT_VALUE = 0;
    private int m_nValue;

    public MutableInt() {
        this(0);
    }

    public MutableInt(@Nonnull Number number) {
        this(number.intValue());
    }

    public MutableInt(int n) {
        this.m_nValue = n;
    }

    @Override
    public int intValue() {
        return this.m_nValue;
    }

    @Override
    public float floatValue() {
        return this.m_nValue;
    }

    @Override
    public double doubleValue() {
        return this.m_nValue;
    }

    @Override
    public long longValue() {
        return this.m_nValue;
    }

    public int inc() {
        return this.inc(1);
    }

    public int inc(int n) {
        this.m_nValue += n;
        this.onAfterChange();
        return this.m_nValue;
    }

    public int inc(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(number.intValue());
    }

    public int dec() {
        return this.inc(-1);
    }

    public int dec(int n) {
        return this.inc(-n);
    }

    public int dec(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(-number.intValue());
    }

    public int divide(int n) {
        this.m_nValue /= n;
        this.onAfterChange();
        return this.m_nValue;
    }

    public int divide(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Divisor");
        return this.divide(number.intValue());
    }

    public int multiply(int n) {
        this.m_nValue *= n;
        this.onAfterChange();
        return this.m_nValue;
    }

    public int multiply(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Multiplicand");
        return this.multiply(number.intValue());
    }

    @Nonnull
    public EChange set(int n) {
        if (this.m_nValue == n) {
            return EChange.UNCHANGED;
        }
        this.m_nValue = n;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange set(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Value");
        return this.set(number.intValue());
    }

    @Override
    public boolean is0() {
        return this.m_nValue == 0;
    }

    @Override
    public boolean isSmaller0() {
        return this.m_nValue < 0;
    }

    @Override
    public boolean isSmallerOrEqual0() {
        return this.m_nValue <= 0;
    }

    @Override
    public boolean isGreater0() {
        return this.m_nValue > 0;
    }

    @Override
    public boolean isGreaterOrEqual0() {
        return this.m_nValue >= 0;
    }

    @Override
    public boolean isEven() {
        return this.m_nValue % 2 == 0;
    }

    @Override
    public int compareTo(@Nonnull MutableInt mutableInt) {
        return CompareHelper.compare(this.m_nValue, mutableInt.m_nValue);
    }

    @Override
    @Nonnull
    public MutableInt getClone() {
        return new MutableInt(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableInt mutableInt = (MutableInt)object;
        return this.m_nValue == mutableInt.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_nValue).getToString();
    }
}

