/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.IURLData;
import com.helger.commons.url.URLParameter;
import com.helger.commons.url.URLParameterList;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class URLData
implements IURLData {
    public static final URLData EMPTY_URL_DATA = new URLData("");
    private final String m_sPath;
    private final URLParameterList m_aParams;
    private final String m_sAnchor;

    public URLData(@Nonnull String string) {
        this(string, null, null);
    }

    public URLData(@Nonnull String string, @Nullable URLParameterList uRLParameterList) {
        this(string, uRLParameterList, null);
    }

    public URLData(@Nonnull String string, @Nullable URLParameterList uRLParameterList, @Nullable String string2) {
        this.m_sPath = ValueEnforcer.notNull(string, "Path");
        this.m_aParams = uRLParameterList;
        this.m_sAnchor = string2;
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.m_sPath;
    }

    @Override
    public boolean hasParams() {
        return CollectionHelper.isNotEmpty(this.m_aParams);
    }

    @Override
    @Nonnegative
    public int getParamCount() {
        return CollectionHelper.getSize(this.m_aParams);
    }

    @Override
    public final boolean containsParam(@Nullable String string) {
        return this.getParam(string) != null;
    }

    @Override
    @Nullable
    public final String getParam(@Nullable String string) {
        if (this.m_aParams != null) {
            for (URLParameter uRLParameter : this.m_aParams) {
                if (!uRLParameter.hasName(string)) continue;
                return uRLParameter.getValue();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public final ICommonsList<String> getAllParams(@Nullable String string) {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        if (this.m_aParams != null) {
            for (URLParameter uRLParameter : this.m_aParams) {
                if (!uRLParameter.hasName(string)) continue;
                commonsArrayList.add(uRLParameter.getValue());
            }
        }
        return commonsArrayList;
    }

    @Override
    @Nullable
    @ReturnsMutableObject(value="design")
    public final URLParameterList directGetAllParams() {
        return this.m_aParams;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final URLParameterList getAllParams() {
        return new URLParameterList(this.m_aParams);
    }

    @Override
    @Nullable
    public String getAnchor() {
        return this.m_sAnchor;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        URLData uRLData = (URLData)object;
        return this.m_sPath.equals(uRLData.m_sPath) && EqualsHelper.equals(this.m_aParams, uRLData.m_aParams) && EqualsHelper.equals(this.m_sAnchor, uRLData.m_sAnchor);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sPath).append((Iterable)this.m_aParams)).append(this.m_sAnchor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("path", this.m_sPath).appendIfNotNull("params", this.m_aParams).appendIfNotNull("anchor", this.m_sAnchor).getToString();
    }
}

