/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IPredicate<T>
extends Predicate<T>,
Serializable {
    @Override
    @Nonnull
    default public IPredicate<T> and(@Nullable Predicate<? super T> predicate) {
        return IPredicate.and(this, predicate);
    }

    @Override
    @Nonnull
    default public IPredicate<T> or(@Nullable Predicate<? super T> predicate) {
        return IPredicate.or(this, predicate);
    }

    @Override
    @Nonnull
    default public IPredicate<T> negate() {
        return object -> !this.test(object);
    }

    @Nonnull
    public static <DATATYPE> IPredicate<DATATYPE> all() {
        return object -> true;
    }

    @Nonnull
    public static <DATATYPE> IPredicate<DATATYPE> none() {
        return object -> false;
    }

    @Nonnull
    public static <DATATYPE> IPredicate<DATATYPE> notNull() {
        return Objects::nonNull;
    }

    @Nonnull
    public static <DATATYPE> IPredicate<DATATYPE> isNull() {
        return Objects::isNull;
    }

    @Nullable
    public static <DATATYPE> IPredicate<DATATYPE> and(@Nullable Predicate<? super DATATYPE> predicate, @Nullable Predicate<? super DATATYPE> predicate2) {
        if (predicate != null) {
            if (predicate2 != null) {
                return object -> predicate.test((Object)object) && predicate2.test((Object)object);
            }
            return object -> predicate.test((Object)object);
        }
        if (predicate2 != null) {
            return object -> predicate2.test((Object)object);
        }
        return null;
    }

    @Nullable
    public static <DATATYPE> IPredicate<DATATYPE> or(@Nullable Predicate<? super DATATYPE> predicate, @Nullable Predicate<? super DATATYPE> predicate2) {
        if (predicate != null) {
            if (predicate2 != null) {
                return object -> predicate.test((Object)object) || predicate2.test((Object)object);
            }
            return object -> predicate.test((Object)object);
        }
        if (predicate2 != null) {
            return object -> predicate2.test((Object)object);
        }
        return null;
    }

    @Nonnull
    public static <T> IPredicate<T> isEqual(@Nullable Object object) {
        return object == null ? IPredicate.isNull() : object2 -> object.equals(object2);
    }
}

