/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.filter.IFileFilter;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileSystemRecursiveIterator
implements IIterableIterator<File> {
    private final int m_nStartLevel;
    private int m_nLevel = 0;
    private final IFileFilter m_aRecursionFilter;
    private final ICommonsList<File> m_aFilesLeft;

    @Nonnegative
    private static int _getLevel(@Nonnull File file) {
        return StringHelper.getCharCount(file.getAbsolutePath(), File.separatorChar);
    }

    public FileSystemRecursiveIterator(@Nonnull String string) {
        this(new File(string), (IFileFilter)null);
    }

    public FileSystemRecursiveIterator(@Nonnull File file) {
        this(file, (IFileFilter)null);
    }

    public FileSystemRecursiveIterator(@Nonnull String string, @Nullable IFileFilter iFileFilter) {
        this(new File(string), iFileFilter);
    }

    public FileSystemRecursiveIterator(@Nonnull File file, @Nullable IFileFilter iFileFilter) {
        ValueEnforcer.notNull(file, "BaseDirectory");
        this.m_nStartLevel = FileSystemRecursiveIterator._getLevel(file);
        this.m_aRecursionFilter = iFileFilter;
        this.m_aFilesLeft = FileHelper.getDirectoryContent(file);
    }

    @Nonnegative
    public int getStartLevel() {
        return this.m_nStartLevel;
    }

    @Nullable
    public IFileFilter getRecursionFilter() {
        return this.m_aRecursionFilter;
    }

    @Override
    public final boolean hasNext() {
        return this.m_aFilesLeft.isNotEmpty();
    }

    @OverrideOnDemand
    protected boolean recurseIntoDirectory(@Nonnull File file) {
        return this.m_aRecursionFilter == null || this.m_aRecursionFilter.test(file);
    }

    @Override
    @Nonnull
    public final File next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        File file = this.m_aFilesLeft.removeFirst();
        this.m_nLevel = FileSystemRecursiveIterator._getLevel(file) - this.m_nStartLevel;
        if (file.isDirectory() && this.recurseIntoDirectory(file)) {
            this.m_aFilesLeft.addAll(0, FileHelper.getDirectoryContent(file));
        }
        return file;
    }

    @Nonnegative
    public final int getLevel() {
        return this.m_nLevel;
    }

    public String toString() {
        return new ToStringGenerator(this).append("filesLeft", this.m_aFilesLeft).getToString();
    }
}

