/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.version;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.compare.IComparable;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Version
implements IComparable<Version> {
    public static final String DEFAULT_VERSION_STRING = "0";
    public static final Version DEFAULT_VERSION = new Version(0, 0, 0, null);
    public static final boolean DEFAULT_PRINT_ZERO_ELEMENTS = false;
    private final int m_nMajor;
    private final int m_nMinor;
    private final int m_nMicro;
    private final String m_sQualifier;

    public Version(@Nonnegative int n) {
        this(n, 0, 0, null);
    }

    public Version(@Nonnegative int n, @Nonnegative int n2) {
        this(n, n2, 0, null);
    }

    public Version(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        this(n, n2, n3, null);
    }

    public Version(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nullable String string) {
        ValueEnforcer.isGE0(n, "Major");
        ValueEnforcer.isGE0(n2, "Minor");
        ValueEnforcer.isGE0(n3, "Micro");
        this.m_nMajor = n;
        this.m_nMinor = n2;
        this.m_nMicro = n3;
        this.m_sQualifier = StringHelper.hasNoText(string) ? null : string;
    }

    @Nonnegative
    public int getMajor() {
        return this.m_nMajor;
    }

    @Nonnegative
    public int getMinor() {
        return this.m_nMinor;
    }

    @Nonnegative
    public int getMicro() {
        return this.m_nMicro;
    }

    @Nullable
    public String getQualifier() {
        return this.m_sQualifier;
    }

    @Override
    public int compareTo(@Nonnull Version version) {
        ValueEnforcer.notNull(version, "Rhs");
        int n = this.m_nMajor - version.m_nMajor;
        if (n == 0 && (n = this.m_nMinor - version.m_nMinor) == 0 && (n = this.m_nMicro - version.m_nMicro) == 0) {
            if (this.m_sQualifier != null) {
                if (version.m_sQualifier != null) {
                    n = this.m_sQualifier.compareTo(version.m_sQualifier);
                    if (n < 0) {
                        n = -1;
                    } else if (n > 0) {
                        n = 1;
                    }
                } else {
                    n = 1;
                }
            } else {
                n = version.m_sQualifier != null ? -1 : 0;
            }
        }
        return n;
    }

    @Override
    public boolean isGreaterThan(@Nonnull Version version) {
        return this.compareTo(version) > 0;
    }

    @Override
    public boolean isGreaterOrEqualThan(@Nonnull Version version) {
        return this.compareTo(version) >= 0;
    }

    @Override
    public boolean isLowerThan(@Nonnull Version version) {
        return this.compareTo(version) < 0;
    }

    @Override
    public boolean isLowerOrEqualThan(@Nonnull Version version) {
        return this.compareTo(version) <= 0;
    }

    @Nonnull
    public String getAsString() {
        return this.getAsString(false);
    }

    @Nonnull
    public String getAsString(boolean bl) {
        return this.getAsString(bl, false);
    }

    @Nonnull
    public String getAsString(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(this.m_sQualifier != null ? this.m_sQualifier : "");
        if (this.m_nMicro > 0 || stringBuilder.length() > 0 || bl) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, this.m_nMicro);
        }
        if (bl2 || this.m_nMinor > 0 || stringBuilder.length() > 0 || bl) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, this.m_nMinor);
        }
        if (bl2 || this.m_nMajor > 0 || stringBuilder.length() > 0 || bl) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, this.m_nMajor);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : DEFAULT_VERSION_STRING;
    }

    @Nonnull
    @Nonempty
    public String getAsStringMajorMinor() {
        return this.m_nMajor + "." + this.m_nMinor;
    }

    @Nonnull
    @Nonempty
    public String getAsStringMajorMinorMicro() {
        return this.m_nMajor + "." + this.m_nMinor + "." + this.m_nMicro;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Version version = (Version)object;
        return this.m_nMajor == version.m_nMajor && this.m_nMinor == version.m_nMinor && this.m_nMicro == version.m_nMicro && EqualsHelper.equals(this.m_sQualifier, version.m_sQualifier);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nMajor).append(this.m_nMinor).append(this.m_nMicro).append(this.m_sQualifier).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("major", this.m_nMajor).append("minor", this.m_nMinor).append("micro", this.m_nMicro).appendIfNotNull("qualifier", this.m_sQualifier).getToString();
    }

    @Nonnull
    public static Version parse(@Nullable String string) {
        return Version.parse(string, true);
    }

    @Nonnull
    @ReturnsMutableCopy
    private static String[] _extSplit(@Nonnull String string) {
        String[] stringArray = StringHelper.getExplodedArray('.', string, 2);
        if (stringArray.length == 2) {
            return stringArray;
        }
        if (StringParser.isInt(stringArray[0])) {
            return stringArray;
        }
        String[] stringArray2 = StringHelper.getExplodedArray('-', string, 2);
        if (stringArray2.length == 1) {
            return stringArray;
        }
        return stringArray2;
    }

    @Nonnull
    public static Version parse(@Nullable String string, boolean bl) {
        String string2;
        int n;
        int n2;
        int n3;
        String string3;
        String string4 = string3 = string == null ? "" : string.trim();
        if (string3.length() == 0) {
            return DEFAULT_VERSION;
        }
        if (bl) {
            String[] stringArray = StringHelper.getExplodedArray('.', string3, 4);
            n3 = stringArray.length > 0 ? StringParser.parseInt(stringArray[0], 0) : 0;
            n2 = stringArray.length > 1 ? StringParser.parseInt(stringArray[1], 0) : 0;
            n = stringArray.length > 2 ? StringParser.parseInt(stringArray[2], 0) : 0;
            string2 = stringArray.length > 3 ? (StringHelper.hasNoText(stringArray[3]) ? null : stringArray[3]) : null;
        } else {
            String string5;
            Integer n4 = null;
            Integer n5 = null;
            boolean bl2 = false;
            String[] stringArray = Version._extSplit(string3);
            Integer n6 = StringParser.parseIntObj(stringArray[0]);
            if (n6 == null && StringHelper.hasText(stringArray[0])) {
                string2 = string3;
                bl2 = true;
            } else {
                string2 = null;
            }
            String string6 = string5 = !bl2 && stringArray.length > 1 ? stringArray[1] : null;
            if (StringHelper.hasText(string5)) {
                stringArray = Version._extSplit(string5);
                n4 = StringParser.parseIntObj(stringArray[0]);
                if (n4 == null && StringHelper.hasText(stringArray[0])) {
                    string2 = string5;
                    bl2 = true;
                }
                String string7 = string5 = !bl2 && stringArray.length > 1 ? stringArray[1] : null;
                if (StringHelper.hasText(string5)) {
                    stringArray = Version._extSplit(string5);
                    n5 = StringParser.parseIntObj(stringArray[0]);
                    if (n5 == null && StringHelper.hasText(stringArray[0])) {
                        string2 = string5;
                        bl2 = true;
                    }
                    if (!bl2 && stringArray.length > 1) {
                        string2 = stringArray[1];
                    }
                }
            }
            n3 = n6 == null ? 0 : n6;
            n2 = n4 == null ? 0 : n4;
            n = n5 == null ? 0 : n5;
            string2 = StringHelper.hasNoText(string2) ? null : string2;
        }
        return new Version(n3, n2, n, string2);
    }
}

