/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class RingBufferLifo<ELEMENTTYPE> {
    private final int m_nCapacity;
    private final Object[] m_aElements;
    private final boolean m_bAllowOverwrite;
    private int m_nWritePos = 0;
    private int m_nAvailable = 0;

    public RingBufferLifo(@Nonnegative int n, boolean bl) {
        ValueEnforcer.isGT0(n, "Capacity");
        this.m_nCapacity = n;
        this.m_aElements = new Object[n];
        this.m_bAllowOverwrite = bl;
    }

    public void reset() {
        this.m_nWritePos = 0;
        this.m_nAvailable = 0;
    }

    @Nonnegative
    public int getCapacity() {
        return this.m_nCapacity;
    }

    @Nonnegative
    public int getAvailable() {
        return this.m_nAvailable;
    }

    @Nonnegative
    public int getRemainingCapacity() {
        return this.m_nCapacity - this.m_nAvailable;
    }

    public boolean isOverwriteAllowed() {
        return this.m_bAllowOverwrite;
    }

    @Nonnull
    public EChange put(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (this.m_nAvailable < this.m_nCapacity) {
            if (this.m_nWritePos >= this.m_nCapacity) {
                this.m_nWritePos = 0;
            }
            this.m_aElements[this.m_nWritePos] = ELEMENTTYPE;
            ++this.m_nWritePos;
            ++this.m_nAvailable;
            return EChange.CHANGED;
        }
        if (this.m_bAllowOverwrite) {
            if (this.m_nWritePos >= this.m_nCapacity) {
                this.m_nWritePos = 0;
            }
            this.m_aElements[this.m_nWritePos] = ELEMENTTYPE;
            ++this.m_nWritePos;
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    @Nullable
    public ELEMENTTYPE take() {
        int n = this.m_nAvailable;
        if (n == 0) {
            return null;
        }
        int n2 = this.m_nWritePos - 1;
        if (n2 < 0) {
            n2 += this.m_nCapacity;
        }
        Object object = this.m_aElements[n2];
        this.m_nWritePos = n2;
        --this.m_nAvailable;
        return (ELEMENTTYPE)GenericReflection.uncheckedCast(object);
    }

    public String toString() {
        return new ToStringGenerator(this).append("Capacity", this.m_nCapacity).append("Elements", this.m_aElements).append("AllowOverwrite", this.m_bAllowOverwrite).append("WritePos", this.m_nWritePos).append("Available", this.m_nAvailable).getToString();
    }
}

