/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mutable;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mutable.IMutableObject;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MutableBoolean
implements IMutableObject<MutableBoolean> {
    public static final boolean DEFAULT_VALUE = false;
    private boolean m_bValue;

    public MutableBoolean() {
        this(false);
    }

    public MutableBoolean(boolean bl) {
        this.m_bValue = bl;
    }

    public MutableBoolean(@Nonnull Boolean bl) {
        this((boolean)bl);
    }

    public MutableBoolean(@Nonnull MutableBoolean mutableBoolean) {
        this(mutableBoolean.m_bValue);
    }

    @OverrideOnDemand
    protected void onAfterChange() {
    }

    public boolean booleanValue() {
        return this.m_bValue;
    }

    @Nonnull
    public Boolean getAsBoolean() {
        return this.m_bValue;
    }

    @Nonnull
    public EChange set(@Nonnull Boolean bl) {
        ValueEnforcer.notNull(bl, "Value");
        return this.set((boolean)bl);
    }

    @Nonnull
    public EChange set(@Nonnull MutableBoolean mutableBoolean) {
        ValueEnforcer.notNull(mutableBoolean, "Value");
        return this.set(mutableBoolean.m_bValue);
    }

    @Nonnull
    public EChange set(boolean bl) {
        if (this.m_bValue == bl) {
            return EChange.UNCHANGED;
        }
        this.m_bValue = bl;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    @Nullable
    public <T> T getIf(@Nonnull Supplier<T> supplier) {
        return this.getIf(supplier, null);
    }

    @Nullable
    public <T> T getIf(@Nonnull Supplier<T> supplier, @Nullable T t) {
        if (this.m_bValue) {
            return supplier.get();
        }
        return t;
    }

    @Override
    public int compareTo(@Nonnull MutableBoolean mutableBoolean) {
        return CompareHelper.compareFalseBeforeTrue(this.m_bValue, mutableBoolean.m_bValue);
    }

    @Override
    @Nonnull
    public MutableBoolean getClone() {
        return new MutableBoolean(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableBoolean mutableBoolean = (MutableBoolean)object;
        return this.m_bValue == mutableBoolean.m_bValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_bValue).getToString();
    }
}

