/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.scope.AbstractMapBasedScope;
import com.helger.commons.scope.ISessionApplicationScope;
import com.helger.commons.scope.ISessionScope;
import com.helger.commons.scope.ScopeHelper;
import com.helger.commons.scope.mgr.MetaScopeFactory;
import com.helger.commons.scope.spi.ScopeSPIManager;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SessionScope
extends AbstractMapBasedScope
implements ISessionScope {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SessionScope.class);
    private final ICommonsMap<String, ISessionApplicationScope> m_aSessionAppScopes = new CommonsHashMap<String, ISessionApplicationScope>();

    public SessionScope(@Nonnull @Nonempty String string) {
        super(string);
        if (ScopeHelper.debugSessionScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Created session scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    public void initScope() {
    }

    @Override
    protected final void destroyOwnedScopes() {
        this.m_aRWLock.writeLocked(() -> {
            for (ISessionApplicationScope iSessionApplicationScope : this.m_aSessionAppScopes.values()) {
                ScopeSPIManager.getInstance().onSessionApplicationScopeEnd(iSessionApplicationScope);
                iSessionApplicationScope.destroyScope();
            }
            this.m_aSessionAppScopes.clear();
        });
    }

    @Override
    protected void preDestroy() {
        if (ScopeHelper.debugSessionScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroying session scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeHelper.debugSessionScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroyed session scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    @Nonnull
    public EContinue selfDestruct() {
        return EContinue.CONTINUE;
    }

    @Nonnull
    @Nonempty
    private String _getApplicationScopeIDPrefix() {
        return this.getID() + '.';
    }

    @Override
    @Nonnull
    @Nonempty
    public String createApplicationScopeID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "ApplicationID");
        return this._getApplicationScopeIDPrefix() + string;
    }

    @Override
    @Nullable
    public String getApplicationIDFromApplicationScopeID(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        String string2 = this._getApplicationScopeIDPrefix();
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return null;
    }

    @Nonnull
    protected ISessionApplicationScope createSessionApplicationScope(@Nonnull @Nonempty String string) {
        return MetaScopeFactory.getScopeFactory().createSessionApplicationScope(string);
    }

    @Override
    @Nullable
    public ISessionApplicationScope getSessionApplicationScope(@Nonnull @Nonempty String string, boolean bl) {
        ValueEnforcer.notEmpty(string, "ApplicationID");
        String string2 = this.createApplicationScopeID(string);
        ISessionApplicationScope iSessionApplicationScope = this.m_aRWLock.readLocked(() -> (ISessionApplicationScope)this.m_aSessionAppScopes.get(string2));
        if (iSessionApplicationScope == null && bl) {
            iSessionApplicationScope = this.m_aRWLock.writeLocked(() -> {
                ISessionApplicationScope iSessionApplicationScope = (ISessionApplicationScope)this.m_aSessionAppScopes.get(string2);
                if (iSessionApplicationScope == null) {
                    iSessionApplicationScope = this.createSessionApplicationScope(string2);
                    this.m_aSessionAppScopes.put(string2, iSessionApplicationScope);
                    iSessionApplicationScope.initScope();
                    ScopeSPIManager.getInstance().onSessionApplicationScopeBegin(iSessionApplicationScope);
                }
                return iSessionApplicationScope;
            });
        }
        return iSessionApplicationScope;
    }

    @Override
    public void restoreSessionApplicationScope(@Nonnull @Nonempty String string, @Nonnull ISessionApplicationScope iSessionApplicationScope) {
        ValueEnforcer.notEmpty(string, "ScopeID");
        ValueEnforcer.notNull(iSessionApplicationScope, "Scope");
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aSessionAppScopes.containsKey(string)) {
                throw new IllegalArgumentException("A session application scope with the ID '" + string + "' is already contained!");
            }
            this.m_aSessionAppScopes.put(string, iSessionApplicationScope);
        });
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, ISessionApplicationScope> getAllSessionApplicationScopes() {
        return this.m_aRWLock.readLocked(() -> (ICommonsMap)this.m_aSessionAppScopes.getClone());
    }

    @Override
    @Nonnegative
    public int getSessionApplicationScopeCount() {
        return this.m_aRWLock.readLocked(() -> this.m_aSessionAppScopes.size());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("sessionAppScopes", this.m_aSessionAppScopes).getToString();
    }
}

