/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.attr;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.attr.IAttributeContainer;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AttributeContainer<KEYTYPE, VALUETYPE>
extends CommonsLinkedHashMap<KEYTYPE, VALUETYPE>
implements IAttributeContainer<KEYTYPE, VALUETYPE> {
    private final CallbackList<IAttributeContainer.IBeforeSetValueCallback<KEYTYPE, VALUETYPE>> m_aBeforeCallbacks = new CallbackList();
    private final CallbackList<IAttributeContainer.IAfterSetValueCallback<KEYTYPE, VALUETYPE>> m_aAfterCallbacks = new CallbackList();

    public AttributeContainer() {
    }

    public AttributeContainer(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        super(map);
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IAttributeContainer.IBeforeSetValueCallback<KEYTYPE, VALUETYPE>> beforeSetValueCallbacks() {
        return this.m_aBeforeCallbacks;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IAttributeContainer.IAfterSetValueCallback<KEYTYPE, VALUETYPE>> afterSetValueCallbacks() {
        return this.m_aAfterCallbacks;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public AttributeContainer<KEYTYPE, VALUETYPE> getClone() {
        return new AttributeContainer<KEYTYPE, VALUETYPE>(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return EqualsHelper.equalsMap(this, (AttributeContainer)object);
    }

    @Override
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this);
        for (Map.Entry entry : this.entrySet()) {
            hashCodeGenerator.append(entry.getKey()).append(entry.getValue());
        }
        return hashCodeGenerator.getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("BeforeCallbacks", this.m_aBeforeCallbacks).append("AfterCallbacks", this.m_aAfterCallbacks).getToString();
    }
}

