/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resource.inmemory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.resource.inmemory.AbstractMemoryReadableResource;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.lang.IHasSize;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReadableResourceByteArray
extends AbstractMemoryReadableResource
implements IHasSize {
    private final byte[] m_aBytes;

    public ReadableResourceByteArray(@Nonnull byte[] byArray) {
        this(null, byArray);
    }

    public ReadableResourceByteArray(@Nullable String string, @Nonnull byte[] byArray) {
        super(StringHelper.hasText(string) ? string : "byte[]");
        this.m_aBytes = ArrayHelper.getCopy(ValueEnforcer.notNull(byArray, "Bytes"));
    }

    @Override
    @Nonnull
    public final InputStream getInputStream() {
        return new NonBlockingByteArrayInputStream(this.m_aBytes);
    }

    @Override
    public final boolean isReadMultiple() {
        return true;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final byte[] getAllBytes() {
        return ArrayHelper.getCopy(this.m_aBytes);
    }

    @Override
    @Nonnegative
    public final int size() {
        return this.m_aBytes.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.m_aBytes.length == 0;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("byte#", this.m_aBytes.length).getToString();
    }
}

