/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.watchdir;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.io.watchdir.EWatchDirAction;
import com.helger.commons.io.watchdir.IWatchDirCallback;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.random.RandomHelper;
import com.helger.commons.system.EOperatingSystem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchDir
implements AutoCloseable {
    private static final Logger s_aLogger = LoggerFactory.getLogger(WatchDir.class);
    private final WatchService m_aWatcher;
    private final Path m_aStartDir;
    private final boolean m_bRecursive;
    private final boolean m_bRegisterRecursiveManually;
    private final ICommonsMap<WatchKey, Path> m_aKeys = new CommonsHashMap<WatchKey, Path>();
    private final AtomicBoolean m_aProcessing = new AtomicBoolean(false);
    private final CallbackList<IWatchDirCallback> m_aCallbacks = new CallbackList();
    private WatchEvent.Modifier[] m_aModifiers = null;

    private void _registerDir(@Nonnull Path path) throws IOException {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Register directory " + path + (this.m_bRecursive && !this.m_bRegisterRecursiveManually ? " (recursively)" : ""));
        }
        WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
        WatchKey watchKey = this.m_aModifiers != null ? path.register(this.m_aWatcher, kindArray, this.m_aModifiers) : path.register(this.m_aWatcher, kindArray);
        this.m_aKeys.put(watchKey, path);
    }

    private void _registerDirRecursive(@Nonnull Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                WatchDir.this._registerDir(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public WatchDir(@Nonnull Path path, boolean bl) throws IOException {
        Enum[] enumArray;
        Enum enum_2;
        Class clazz;
        ValueEnforcer.notNull(path, "Directory");
        ValueEnforcer.isTrue(Files.isDirectory(path, new LinkOption[0]), () -> "Provided path is not a directory: " + path);
        this.m_aWatcher = FileSystems.getDefault().newWatchService();
        this.m_aStartDir = path.toRealPath(new LinkOption[0]);
        this.m_bRecursive = bl;
        boolean bl2 = bl;
        if (bl && EOperatingSystem.WINDOWS.isCurrentOS() && (clazz = GenericReflection.getClassFromNameSafe("com.sun.nio.file.ExtendedWatchEventModifier")) != null && (enum_2 = ArrayHelper.findFirst(enumArray = (Enum[])clazz.getEnumConstants(), enum_ -> enum_.name().equals("FILE_TREE"))) != null) {
            this.m_aModifiers = new WatchEvent.Modifier[]{(WatchEvent.Modifier)((Object)enum_2)};
            bl2 = false;
        }
        this.m_bRegisterRecursiveManually = bl2;
        if (this.m_bRegisterRecursiveManually) {
            this._registerDirRecursive(this.m_aStartDir);
        } else {
            this._registerDir(this.m_aStartDir);
        }
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IWatchDirCallback> callbacks() {
        return this.m_aCallbacks;
    }

    @Nonnull
    public Path getStartDirectory() {
        return this.m_aStartDir;
    }

    public boolean isRecursive() {
        return this.m_bRecursive;
    }

    @Override
    public void close() throws IOException {
        try {
            this.stopProcessing();
        }
        finally {
            this.m_aWatcher.close();
        }
    }

    public void stopProcessing() {
        this.m_aProcessing.set(false);
    }

    public boolean isProcessing() {
        return this.m_aProcessing.get();
    }

    public void processEvents() {
        s_aLogger.info("Start processing directory change events in '" + this.m_aStartDir + "'" + (this.m_bRecursive ? " (recursively)" : ""));
        if (this.m_aCallbacks.isEmpty()) {
            throw new IllegalStateException("No callback registered for watching directory changes in " + this.m_aStartDir);
        }
        this.m_aProcessing.set(true);
        while (this.m_aProcessing.get()) {
            WatchKey watchKey;
            try {
                watchKey = this.m_aWatcher.poll(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ClosedWatchServiceException exception) {
                break;
            }
            if (watchKey == null) continue;
            Path path = (Path)this.m_aKeys.get(watchKey);
            if (path == null) {
                s_aLogger.error("WatchKey " + watchKey + " not recognized!!");
                continue;
            }
            for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                EWatchDirAction eWatchDirAction;
                WatchEvent.Kind<?> kind = watchEvent.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    s_aLogger.warn("Got an overflow event on directory " + path);
                    continue;
                }
                Path path2 = (Path)watchEvent.context();
                Path path3 = path.resolve(path2);
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    eWatchDirAction = EWatchDirAction.CREATE;
                } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                    eWatchDirAction = EWatchDirAction.DELETE;
                } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                    eWatchDirAction = EWatchDirAction.MODIFY;
                } else {
                    eWatchDirAction = null;
                    s_aLogger.error("Unsupported event kind: " + kind + " on path: '" + path3 + "'");
                }
                if (eWatchDirAction != null) {
                    this.m_aCallbacks.forEach(iWatchDirCallback -> iWatchDirCallback.onAction(eWatchDirAction, path3));
                }
                if (!this.m_bRecursive || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                try {
                    if (!Files.isDirectory(path3, LinkOption.NOFOLLOW_LINKS)) continue;
                    if (this.m_bRegisterRecursiveManually) {
                        this._registerDirRecursive(path3);
                        continue;
                    }
                    if (!path3.equals(path)) continue;
                    this._registerDir(path3);
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("Error registering handler ony the fly for " + path3, iOException);
                }
            }
            boolean bl = watchKey.reset();
            if (bl) continue;
            s_aLogger.info("Unregister directory " + path);
            this.m_aKeys.remove(watchKey);
            if (!this.m_aKeys.isEmpty()) continue;
            break;
        }
        s_aLogger.info("Finished processing directory change events in '" + this.m_aStartDir + "'");
    }

    public void runAsync() {
        Thread thread = new Thread(this::processEvents, "WatchDir-" + this.m_aStartDir + "-" + RandomHelper.getRandom().nextInt());
        thread.setDaemon(true);
        thread.start();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static WatchDir createAsyncRunningWatchDir(@Nonnull Path path, boolean bl, @Nonnull IWatchDirCallback iWatchDirCallback) throws IOException {
        WatchDir watchDir = new WatchDir(path, bl);
        watchDir.callbacks().add(iWatchDirCallback);
        watchDir.runAsync();
        return watchDir;
    }
}

