/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.NonBlockingProperties;
import com.helger.commons.system.SystemProperties;
import com.helger.commons.url.ISimpleURL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PropertiesHelper {
    private PropertiesHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> getAsStringMap(@Nonnull Properties properties) {
        ValueEnforcer.notNull(properties, "Props");
        CommonsHashMap<String, String> commonsHashMap = new CommonsHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            commonsHashMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return commonsHashMap;
    }

    @Nullable
    public static NonBlockingProperties loadProperties(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull(iSimpleURL, "URL");
        try {
            return PropertiesHelper.loadProperties(new URLResource(iSimpleURL));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Nullable
    public static NonBlockingProperties loadProperties(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        return PropertiesHelper.loadProperties(new FileSystemResource(file));
    }

    @Nullable
    public static NonBlockingProperties loadProperties(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull(iReadableResource, "Resource");
        InputStream inputStream = iReadableResource.getInputStream();
        if (inputStream == null) {
            return null;
        }
        return PropertiesHelper.loadProperties(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static NonBlockingProperties loadProperties(@Nonnull @WillClose InputStream inputStream) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        InputStream inputStream2 = StreamHelper.getBuffered(inputStream);
        try {
            NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
            nonBlockingProperties.load(inputStream2);
            NonBlockingProperties nonBlockingProperties2 = nonBlockingProperties;
            return nonBlockingProperties2;
        }
        catch (IOException iOException) {
            NonBlockingProperties nonBlockingProperties = null;
            return nonBlockingProperties;
        }
        finally {
            StreamHelper.close(inputStream2);
            StreamHelper.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static NonBlockingProperties loadProperties(@Nonnull @WillClose Reader reader) {
        ValueEnforcer.notNull(reader, "Reader");
        Reader reader2 = StreamHelper.getBuffered(reader);
        try {
            NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
            nonBlockingProperties.load(reader2);
            NonBlockingProperties nonBlockingProperties2 = nonBlockingProperties;
            return nonBlockingProperties2;
        }
        catch (IOException iOException) {
            NonBlockingProperties nonBlockingProperties = null;
            return nonBlockingProperties;
        }
        finally {
            StreamHelper.close(reader2);
            StreamHelper.close(reader);
        }
    }

    @Nullable
    public static String expandSystemProperties(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("${", 0);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = string.length();
        int n3 = 0;
        while (n < n2) {
            int n4;
            if (n > n3) {
                stringBuilder.append(string.substring(n3, n));
                n3 = n;
            }
            if ((n4 = n + 2) < n2 && string.charAt(n4) == '{') {
                if ((n4 = string.indexOf("}}", n4)) == -1 || n4 + 2 == n2) {
                    stringBuilder.append(string.substring(n));
                    break;
                }
                stringBuilder.append(string.substring(n, ++n4 + 1));
            } else {
                while (n4 < n2 && string.charAt(n4) != '}') {
                    ++n4;
                }
                if (n4 == n2) {
                    stringBuilder.append(string.substring(n, n4));
                    break;
                }
                String string2 = string.substring(n + 2, n4);
                if (string2.equals("/")) {
                    stringBuilder.append(File.separatorChar);
                } else {
                    String string3 = SystemProperties.getPropertyValue(string2);
                    if (string3 == null) {
                        return string;
                    }
                    stringBuilder.append(string3);
                }
            }
            if ((n = string.indexOf("${", n3 = n4 + 1)) != -1) continue;
            if (n3 >= n2) break;
            stringBuilder.append(string.substring(n3, n2));
            break;
        }
        return stringBuilder.toString();
    }
}

