/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.system;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.string.StringParser;
import com.helger.commons.system.SystemProperties;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class JavaVersionHelper {
    public static final double JAVA_CLASS_VERSION = StringParser.parseDouble(SystemProperties.getJavaClassVersion(), Double.NaN);
    public static final int JAVA_MAJOR_VERSION;
    public static final int JAVA_MINOR_VERSION;
    public static final int JAVA_MICRO_VERSION;
    private static final Logger s_aLogger;
    private static final JavaVersionHelper s_aInstance;

    @Nonnull
    @ReturnsMutableCopy
    static int[] getAsUnifiedVersion(@Nonnull String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = string;
        if (string2.startsWith("1.")) {
            int n4 = (string2 = string2.substring(2)).indexOf(46);
            if (n4 < 0) {
                throw new IllegalStateException("Unexpected Java version string '" + string + "'");
            }
            n = StringParser.parseInt(string2.substring(0, n4), -1);
            if (n < 0) {
                throw new IllegalStateException("Failed to determine Java major version from '" + string + "'");
            }
            int n5 = string2.indexOf(95);
            if (n5 < 0) {
                throw new IllegalStateException("Unexpected Java version string '" + string + "'");
            }
            n2 = StringParser.parseInt(string2.substring(n5 + 1), -1);
            if (n2 < 0) {
                throw new IllegalStateException("Failed to determine Java minor version from '" + string + "'");
            }
            n3 = -1;
        } else {
            int n6;
            int n7;
            int n8 = string2.indexOf(45);
            if (n8 > 0) {
                string2 = string2.substring(0, n8);
            }
            if ((n7 = string2.indexOf(43)) > 0) {
                string2 = string2.substring(0, n7);
            }
            if ((n = (n6 = string2.indexOf(46)) < 0 ? StringParser.parseInt(string2, -1) : StringParser.parseInt(string2.substring(0, n6), -1)) < 0) {
                throw new IllegalStateException("Failed to determine Java major version from '" + string + "'");
            }
            if (n6 >= 0) {
                int n9 = string2.indexOf(46, n6 + 1);
                n2 = n9 < 0 ? StringParser.parseInt(string2.substring(n6 + 1), -1) : StringParser.parseInt(string2.substring(n6 + 1, n9), -1);
                if (n2 < 0) {
                    throw new IllegalStateException("Failed to determine Java minor version from '" + string + "'");
                }
                if (n9 >= 0 && (n3 = StringParser.parseInt(string2.substring(n9 + 1), -1)) < 0) {
                    throw new IllegalStateException("Failed to determine Java micro version from '" + string + "'");
                }
            }
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Java version '" + string + "' split into " + n + "." + n2 + (n3 >= 0 ? "." + n3 : ""));
        }
        return new int[]{n, n2, n3};
    }

    private JavaVersionHelper() {
    }

    public static boolean isAtLeast(int n, int n2) {
        if (JAVA_MAJOR_VERSION > n) {
            return true;
        }
        if (JAVA_MAJOR_VERSION == n) {
            return JAVA_MINOR_VERSION >= n2;
        }
        return false;
    }

    static {
        s_aLogger = LoggerFactory.getLogger(JavaVersionHelper.class);
        int[] nArray = JavaVersionHelper.getAsUnifiedVersion(SystemProperties.getJavaVersion());
        JAVA_MAJOR_VERSION = nArray[0];
        JAVA_MINOR_VERSION = nArray[1];
        JAVA_MICRO_VERSION = nArray[2];
        s_aInstance = new JavaVersionHelper();
    }
}

