/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.statistics;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StatisticsHandlerKeyedCounter
implements IMutableStatisticsHandlerKeyedCounter {
    private final transient SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final AtomicInteger m_aInvocationCount = new AtomicInteger();
    private final ICommonsMap<String, Value> m_aMap = new CommonsHashMap<String, Value>();

    @Override
    @Nonnegative
    public int getInvocationCount() {
        return this.m_aInvocationCount.intValue();
    }

    @Override
    public void increment(@Nullable String string, long l) {
        this.m_aInvocationCount.incrementAndGet();
        this.m_aRWLock.writeLocked(() -> {
            Value value = (Value)this.m_aMap.get(string);
            if (value == null) {
                this.m_aMap.put(string, new Value(l));
            } else {
                value.increment(l);
            }
        });
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllKeys() {
        return this.m_aRWLock.readLocked(this.m_aMap::copyOfKeySet);
    }

    @Override
    @CheckForSigned
    public long getCount(@Nullable String string) {
        return this.m_aRWLock.readLocked(() -> {
            Value value = (Value)this.m_aMap.get(string);
            return value == null ? -1L : value.getCount();
        });
    }

    @Override
    @CheckForSigned
    public int getInvocationCount(@Nullable String string) {
        return this.m_aRWLock.readLocked(() -> {
            Value value = (Value)this.m_aMap.get(string);
            return value == null ? -1 : value.getInvocationCount();
        });
    }

    @NotThreadSafe
    private static final class Value
    implements Serializable {
        private int m_nInvocationCount = 1;
        private long m_nCount;

        public Value(long l) {
            this.m_nCount = l;
        }

        public void increment(long l) {
            ++this.m_nInvocationCount;
            this.m_nCount += l;
        }

        @Nonnegative
        public int getInvocationCount() {
            return this.m_nInvocationCount;
        }

        public long getCount() {
            return this.m_nCount;
        }

        public String toString() {
            return new ToStringGenerator(null).append("invocations", this.m_nInvocationCount).append("count", this.m_nCount).getToString();
        }
    }
}

