/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streamprovider;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.io.ByteArrayWrapper;
import com.helger.commons.io.IHasByteArray;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ByteArrayInputStreamProvider
implements IHasByteArray,
Serializable {
    public static final boolean DEFAULT_COPY_NEEDED = false;
    private final ByteArrayWrapper m_aBytes;

    public ByteArrayInputStreamProvider(@Nonnull byte[] byArray) {
        this(byArray, 0, byArray.length, false);
    }

    public ByteArrayInputStreamProvider(@Nonnull byte[] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    public ByteArrayInputStreamProvider(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this(byArray, n, n2, false);
    }

    public ByteArrayInputStreamProvider(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this.m_aBytes = new ByteArrayWrapper(byArray, n, n2, bl);
    }

    @Override
    public final boolean isCopy() {
        return this.m_aBytes.isCopy();
    }

    @Nonnull
    @Deprecated
    @ReturnsMutableCopy
    public final byte[] getData() {
        return this.getAllBytes();
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final byte[] bytes() {
        return this.m_aBytes.bytes();
    }

    @Override
    @Nonnegative
    public final int getOffset() {
        return this.m_aBytes.getOffset();
    }

    @Nonnegative
    @Deprecated
    public final int getLength() {
        return this.size();
    }

    @Override
    @Nonnegative
    public final int size() {
        return this.m_aBytes.size();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Bytes", this.m_aBytes).getToString();
    }
}

