/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.datetime;

import com.helger.commons.datetime.PDTConfig;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PDTFactory {
    private PDTFactory() {
    }

    @Nonnull
    private static ZoneId _getZoneId() {
        return PDTConfig.getDefaultZoneId();
    }

    @Nonnull
    public static ZonedDateTime getCurrentZonedDateTime() {
        return ZonedDateTime.now(PDTFactory._getZoneId());
    }

    @Nonnull
    public static ZonedDateTime getCurrentZonedDateTimeUTC() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : offsetDateTime.toZonedDateTime();
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : ZonedDateTime.of(localDateTime, PDTFactory._getZoneId());
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable LocalDate localDate) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(localDate));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable YearMonth yearMonth) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(yearMonth));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable Year year) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(year));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable LocalTime localTime) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(localTime));
    }

    @Nonnull
    public static ZonedDateTime createZonedDateTime(int n, Month month, int n2) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(n, month, n2));
    }

    @Nonnull
    public static ZonedDateTime createZonedDateTime(int n, @Nonnull Month month, int n2, int n3, int n4, int n5) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable Instant instant) {
        return instant == null ? null : ZonedDateTime.ofInstant(instant, PDTFactory._getZoneId());
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime();
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable Date date) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(date));
    }

    @Nullable
    public static ZonedDateTime createZonedDateTime(@Nullable Timestamp timestamp) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(timestamp));
    }

    @Nonnull
    public static ZonedDateTime createZonedDateTime(long l) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(l));
    }

    @Nonnull
    public static ZonedDateTime createZonedDateTime(@Nullable Number number) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(number));
    }

    @Nonnegative
    public static OffsetDateTime getCurrentOffsetDateTime() {
        return OffsetDateTime.now(PDTFactory._getZoneId());
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : zonedDateTime.toOffsetDateTime();
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable LocalDateTime localDateTime) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createZonedDateTime(localDateTime));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable LocalDate localDate) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createZonedDateTime(localDate));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable YearMonth yearMonth) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createZonedDateTime(yearMonth));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable Year year) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createZonedDateTime(year));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable LocalTime localTime) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createZonedDateTime(localTime));
    }

    @Nonnull
    public static OffsetDateTime createOffsetDateTime(int n, Month month, int n2) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createZonedDateTime(n, month, n2));
    }

    @Nonnull
    public static OffsetDateTime createOffsetDateTime(int n, @Nonnull Month month, int n2, int n3, int n4, int n5) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createZonedDateTime(n, month, n2, n3, n4, n5));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable Instant instant) {
        return instant == null ? null : OffsetDateTime.ofInstant(instant, PDTFactory._getZoneId());
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable Date date) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(date));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable Timestamp timestamp) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(timestamp));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable GregorianCalendar gregorianCalendar) {
        return PDTFactory.createOffsetDateTime(gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime());
    }

    @Nonnull
    public static OffsetDateTime createOffsetDateTime(long l) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(l));
    }

    @Nullable
    public static OffsetDateTime createOffsetDateTime(@Nullable Number number) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(number));
    }

    @Nonnegative
    public static LocalDateTime getCurrentLocalDateTime() {
        return LocalDateTime.now(PDTFactory._getZoneId());
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : zonedDateTime.toLocalDateTime();
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : offsetDateTime.toLocalDateTime();
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable LocalDate localDate) {
        return localDate == null ? null : localDate.atStartOfDay();
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable YearMonth yearMonth) {
        return PDTFactory.createLocalDateTime(PDTFactory.createLocalDate(yearMonth));
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable Year year) {
        return PDTFactory.createLocalDateTime(PDTFactory.createLocalDate(year));
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable LocalTime localTime) {
        return localTime == null ? null : localTime.atDate(LocalDate.ofEpochDay(0L));
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(int n, @Nonnull Month month, int n2) {
        return PDTFactory.createLocalDateTime(n, month, n2, 0, 0, 0);
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(int n, @Nonnull Month month, int n2, int n3, int n4) {
        return PDTFactory.createLocalDateTime(n, month, n2, n3, n4, 0);
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(int n, @Nonnull Month month, int n2, int n3, int n4, int n5) {
        return LocalDateTime.of(n, month, n2, n3, n4, n5);
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable Instant instant) {
        return instant == null ? null : LocalDateTime.ofInstant(instant, PDTFactory._getZoneId());
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable Date date) {
        return date == null ? null : PDTFactory.createLocalDateTime(date.toInstant());
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable Timestamp timestamp) {
        return timestamp == null ? null : timestamp.toLocalDateTime();
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : PDTFactory.createLocalDateTime(gregorianCalendar.toZonedDateTime());
    }

    @Nonnull
    public static LocalDateTime createLocalDateTime(long l) {
        return PDTFactory.createLocalDateTime(Instant.ofEpochMilli(l));
    }

    @Nullable
    public static LocalDateTime createLocalDateTime(@Nullable Number number) {
        return number == null ? null : PDTFactory.createLocalDateTime(number.longValue());
    }

    @Nonnegative
    public static LocalDate getCurrentLocalDate() {
        return LocalDate.now(PDTFactory._getZoneId());
    }

    @Nullable
    public static LocalDate createLocalDate(int n, @Nonnull Month month, int n2) {
        return LocalDate.of(n, month, n2);
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime().toLocalDate();
    }

    @Nonnull
    public static LocalDate createLocalDate(long l) {
        return PDTFactory.createLocalDateTime(l).toLocalDate();
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable Instant instant) {
        return instant == null ? null : PDTFactory.createLocalDateTime(instant).toLocalDate();
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable Date date) {
        return date == null ? null : PDTFactory.createLocalDate(date.toInstant());
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable YearMonth yearMonth) {
        return yearMonth == null ? null : yearMonth.atDay(1);
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable Year year) {
        return year == null ? null : year.atDay(1);
    }

    @Nullable
    public static LocalDate createLocalDate(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : localDateTime.toLocalDate();
    }

    @Nonnegative
    public static LocalTime getCurrentLocalTime() {
        return LocalTime.now(PDTFactory._getZoneId());
    }

    @Nullable
    public static LocalTime createLocalTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime().toLocalTime();
    }

    @Nullable
    public static LocalTime createLocalTime(@Nullable Instant instant) {
        return instant == null ? null : PDTFactory.createLocalDateTime(instant).toLocalTime();
    }

    @Nullable
    public static LocalTime createLocalTime(@Nullable Date date) {
        return date == null ? null : PDTFactory.createLocalTime(date.toInstant());
    }

    @Nullable
    public static LocalTime createLocalTime(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : localDateTime.toLocalTime();
    }

    @Nullable
    public static LocalTime createLocalTime(int n, int n2, int n3) {
        return LocalTime.of(n, n2, n3);
    }

    @Nullable
    public static Date createDate(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : Date.from(zonedDateTime.toInstant());
    }

    @Nullable
    public static Date createDate(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : Date.from(offsetDateTime.toInstant());
    }

    @Nullable
    public static Date createDate(@Nullable LocalDateTime localDateTime) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(localDateTime));
    }

    @Nullable
    public static Date createDate(@Nullable LocalDate localDate) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(localDate));
    }

    @Nullable
    public static Date createDate(@Nullable LocalTime localTime) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(localTime));
    }

    @Nonnull
    public static Calendar createCalendar() {
        return Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
    }

    @Nonnull
    public static GregorianCalendar createGregorianCalendar() {
        return new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
    }

    @Nonnegative
    public static int getCurrentYear() {
        return PDTFactory.getCurrentLocalDate().getYear();
    }

    @Nonnull
    public static Year getCurrentYearObj() {
        return Year.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static int getCurrentMonth() {
        return PDTFactory.getCurrentLocalDate().getMonthValue();
    }

    @Nonnull
    public static Month getCurrentMonthObj() {
        return PDTFactory.getCurrentLocalDate().getMonth();
    }

    @Nonnegative
    public static int getCurrentDayOfMonth() {
        return PDTFactory.getCurrentLocalDate().getDayOfMonth();
    }

    @Nonnull
    public static MonthDay getCurrentMonthDay() {
        return MonthDay.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static YearMonth getCurrentYearMonth() {
        return YearMonth.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static Instant getCurrentInstant() {
        return Instant.now(Clock.system(PDTFactory._getZoneId()));
    }

    public static long getCurrentMillis() {
        return PDTFactory.getCurrentInstant().toEpochMilli();
    }

    public static long getMillis(@Nonnull LocalDate localDate) {
        return PDTFactory.createZonedDateTime(localDate).toInstant().toEpochMilli();
    }

    public static long getMillis(@Nonnull LocalTime localTime) {
        return PDTFactory.createZonedDateTime(localTime).toInstant().toEpochMilli();
    }

    public static long getMillis(@Nonnull LocalDateTime localDateTime) {
        return PDTFactory.createZonedDateTime(localDateTime).toInstant().toEpochMilli();
    }

    public static long getMillis(@Nonnull OffsetDateTime offsetDateTime) {
        return offsetDateTime.toInstant().toEpochMilli();
    }

    public static long getMillis(@Nonnull ZonedDateTime zonedDateTime) {
        return zonedDateTime.toInstant().toEpochMilli();
    }
}

