/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.IHasByteArray;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@MustImplementEqualsAndHashcode
public final class ByteArrayWrapper
implements IHasByteArray,
Serializable {
    private final byte[] m_aBytes;
    private final int m_nOffset;
    private final int m_nLength;
    private final boolean m_bIsCopy;

    public ByteArrayWrapper(@Nonnull byte[] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    public ByteArrayWrapper(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this.m_aBytes = bl ? ArrayHelper.getCopy(byArray, n, n2) : byArray;
        this.m_nOffset = bl ? 0 : n;
        this.m_nLength = n2;
        this.m_bIsCopy = bl;
    }

    @Override
    public boolean isCopy() {
        return this.m_bIsCopy;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public byte[] bytes() {
        return this.m_aBytes;
    }

    @Override
    @Nonnegative
    public int getOffset() {
        return this.m_nOffset;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_nLength;
    }

    @Override
    public boolean isEmpty() {
        return this.m_nLength == 0;
    }

    @Override
    public boolean isNotEmpty() {
        return this.m_nLength > 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ByteArrayWrapper byteArrayWrapper = (ByteArrayWrapper)object;
        return Arrays.equals(this.m_aBytes, byteArrayWrapper.m_aBytes) && this.m_nOffset == byteArrayWrapper.m_nOffset && this.m_nLength == byteArrayWrapper.m_nLength;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aBytes).append(this.m_nOffset).append(this.m_nLength).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("byte[]#", this.m_aBytes.length).append("Offset", this.m_nOffset).append("Length", this.m_nLength).append("IsCopy", this.m_bIsCopy).getToString();
    }
}

