/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.EncodeException;
import com.helger.commons.codec.IByteArrayCodec;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonClosingOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlateCodec
implements IByteArrayCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlateCodec.class);

    public static boolean isZlibHead(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (n2 >= 2) {
            int n3 = byArray[n] & 0xFF;
            int n4 = byArray[n + 1] & 0xFF;
            if ((n3 & 0xF) == 8 && (n3 >> 4) + 8 <= 15 && ((n3 << 8) + n4) % 31 == 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void decode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        if (!FlateCodec.isZlibHead(byArray, n, n2)) {
            LOGGER.warn("ZLib header not found");
        }
        try (InflaterInputStream inflaterInputStream = new InflaterInputStream(new NonBlockingByteArrayInputStream(byArray, n, n2));){
            if (StreamHelper.copyInputStreamToOutputStream(inflaterInputStream, outputStream).isFailure()) {
                throw new DecodeException("Failed to flate decode!");
            }
        }
        catch (IOException iOException) {
            throw new DecodeException("Failed to flate encode", iOException);
        }
    }

    @Override
    public void encode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try (DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(new NonClosingOutputStream(outputStream));){
            if (StreamHelper.copyInputStreamToOutputStream(new NonBlockingByteArrayInputStream(byArray, n, n2), deflaterOutputStream).isFailure()) {
                throw new EncodeException("Failed to flate encode!");
            }
        }
        catch (IOException iOException) {
            throw new EncodeException("Failed to flate encode", iOException);
        }
    }
}

