/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang.priviledged;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.lang.priviledged.AccessControllerHelper;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IPrivilegedAction<T>
extends PrivilegedAction<T> {
    @Nullable
    default public T invokeSafe() {
        if (System.getSecurityManager() == null) {
            return this.run();
        }
        return AccessControllerHelper.call(this);
    }

    @Nonnull
    public static IPrivilegedAction<Object> asVoid(@Nonnull Runnable runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }

    @Nonnull
    public static IPrivilegedAction<ClassLoader> classLoaderGetParent(@Nonnull ClassLoader classLoader) {
        return classLoader::getParent;
    }

    @Nonnull
    public static IPrivilegedAction<ClassLoader> getClassLoader(@Nonnull Class<?> clazz) {
        return clazz::getClassLoader;
    }

    @Nonnull
    public static IPrivilegedAction<ClassLoader> getContextClassLoader() {
        return Thread.currentThread()::getContextClassLoader;
    }

    @Nonnull
    public static IPrivilegedAction<Object> setContextClassLoader(@Nonnull ClassLoader classLoader) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        return IPrivilegedAction.asVoid(() -> Thread.currentThread().setContextClassLoader(classLoader));
    }

    @Nonnull
    public static IPrivilegedAction<ClassLoader> getSystemClassLoader() {
        return ClassLoader::getSystemClassLoader;
    }

    @Nonnull
    public static IPrivilegedAction<String> systemClearProperty(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Key");
        return () -> System.clearProperty(string);
    }

    @Nonnull
    public static IPrivilegedAction<String> systemGetProperty(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Key");
        return () -> System.getProperty(string);
    }

    @Nonnull
    public static IPrivilegedAction<Properties> systemGetProperties() {
        return System::getProperties;
    }

    @Nonnull
    public static IPrivilegedAction<String> systemSetProperty(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string, "Key");
        ValueEnforcer.notNull(string2, "Value");
        return () -> System.setProperty(string, string2);
    }

    @Nonnull
    public static IPrivilegedAction<ProxySelector> proxySelectorGetDefault() {
        return ProxySelector::getDefault;
    }

    @Nonnull
    public static IPrivilegedAction<Object> proxySelectorSetDefault(@Nullable ProxySelector proxySelector) {
        return IPrivilegedAction.asVoid(() -> ProxySelector.setDefault(proxySelector));
    }

    @Nonnull
    public static IPrivilegedAction<Object> authenticatorSetDefault(@Nullable Authenticator authenticator) {
        return IPrivilegedAction.asVoid(() -> Authenticator.setDefault(authenticator));
    }
}

