/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.random;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.lang.TimeValue;
import com.helger.commons.string.StringParser;
import com.helger.commons.system.SystemProperties;
import com.helger.commons.timing.StopWatch;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class VerySecureRandom {
    public static final int DEFAULT_RE_SEED_INTERVAL = 20;
    private static final Logger LOGGER;
    private static final int SEED_BYTE_COUNT = 64;
    private static final int WARNING_MILLISECONDS_THRESHOLD = 500;
    private static final SecureRandom s_aSecureRandom;
    private static final AtomicInteger s_aReSeedInterval;
    private static final AtomicInteger s_aCounter;
    private static final VerySecureRandom s_aInstance;

    @Nonnull
    private static SecureRandom _createSecureRandomInstance() {
        SecureRandom secureRandom;
        block9: {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Trying to get SecureRandom: IBMSecureRandom, IBMJCE");
                }
                secureRandom = SecureRandom.getInstance("IBMSecureRandom", "IBMJCE");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using SecureRandom: IBMSecureRandom, IBMJCE");
                }
            }
            catch (Exception exception) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Trying to get SecureRandom: NativePRNGNonBlocking");
                    }
                    secureRandom = SecureRandom.getInstance("NativePRNGNonBlocking");
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Using SecureRandom: NativePRNGNonBlocking");
                    }
                }
                catch (Exception exception2) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Trying to get default SecureRandom");
                    }
                    secureRandom = new SecureRandom();
                    if (!LOGGER.isDebugEnabled()) break block9;
                    LOGGER.debug("Using default SecureRandom");
                }
            }
        }
        return secureRandom;
    }

    private VerySecureRandom() {
    }

    public static void setReSeedInterval(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "ReseedInterval");
        s_aReSeedInterval.set(n);
    }

    @Nonnegative
    public static int getReSeedInterval() {
        return s_aReSeedInterval.get();
    }

    @Nonnull
    public static SecureRandom getInstance() {
        int n = VerySecureRandom.getReSeedInterval();
        if (n > 0 && s_aCounter.incrementAndGet() % n == 0) {
            TimeValue timeValue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Re-seeding VerySecureRandom started");
            }
            if ((timeValue = StopWatch.runMeasured(() -> s_aSecureRandom.setSeed(s_aSecureRandom.generateSeed(64)))).getAsMillis() > 500L && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Re-seeding VerySecureRandom took too long (" + timeValue.getAsMillis() + " milliseconds) - you may consider using '/dev/urandom'");
            }
        }
        return s_aSecureRandom;
    }

    static {
        int n;
        LOGGER = LoggerFactory.getLogger(VerySecureRandom.class);
        s_aReSeedInterval = new AtomicInteger(20);
        s_aCounter = new AtomicInteger(0);
        Object object = SystemProperties.getPropertyValueOrNull("ph.securerandom-reseed-interval");
        Serializable serializable = StringParser.parseIntObj((String)object);
        if (serializable != null && (n = ((Integer)serializable).intValue()) >= 0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("VerySecureRandom uses by default re-seed interval " + n);
            }
            s_aReSeedInterval.set(n);
        }
        object = VerySecureRandom._createSecureRandomInstance();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Generating intial seed for VerySecureRandom - 64 bytes");
        }
        serializable = StopWatch.createdStarted();
        byte[] byArray = ((SecureRandom)object).generateSeed(64);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished generating intial seed for VerySecureRandom");
        }
        s_aSecureRandom = VerySecureRandom._createSecureRandomInstance();
        s_aSecureRandom.setSeed(byArray);
        long l = ((StopWatch)serializable).stopAndGetMillis();
        if (l > 500L && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Initially seeding VerySecureRandom took too long (" + l + " milliseconds) - you may consider using '/dev/urandom'");
        }
        s_aInstance = new VerySecureRandom();
    }
}

