/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.locale.country;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CountryCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(CountryCache.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aCountries = new CommonsHashSet<String>();

    protected CountryCache() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static CountryCache getInstance() {
        CountryCache countryCache = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return countryCache;
    }

    @Nonnull
    EChange addCountry(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Country");
        String string2 = LocaleHelper.getValidCountryCode(string);
        ValueEnforcer.isTrue(string2 != null, () -> "illegal country code '" + string + "'");
        ValueEnforcer.isTrue(string.equals(string2), () -> "invalid casing of '" + string + "'");
        return this.m_aRWLock.writeLocked(() -> this.m_aCountries.addObject(string2));
    }

    @Nullable
    public Locale getCountry(@Nullable Locale locale) {
        return locale == null ? null : this.getCountry(locale.getCountry());
    }

    @Nullable
    public Locale getCountry(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        if (string.indexOf(95) >= 0) {
            return this.getCountry(LocaleCache.getInstance().getLocale(string));
        }
        String string2 = LocaleHelper.getValidCountryCode(string);
        if (!this.containsCountry(string2) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Trying to retrieve unsupported country '" + string + "'");
        }
        return LocaleCache.getInstance().getLocale("", string2, "");
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllCountries() {
        return this.m_aRWLock.readLocked(this.m_aCountries::getClone);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<Locale> getAllCountryLocales() {
        return this.m_aRWLock.readLocked(() -> {
            LocaleCache localeCache = LocaleCache.getInstance();
            return new CommonsHashSet<Locale>(this.m_aCountries, string -> localeCache.getLocale("", (String)string, ""));
        });
    }

    public boolean containsCountry(@Nullable Locale locale) {
        return locale != null && this.containsCountry(locale.getCountry());
    }

    public boolean containsCountry(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = LocaleHelper.getValidCountryCode(string);
        if (string2 == null) {
            return false;
        }
        return this.m_aRWLock.readLocked(() -> this.m_aCountries.contains(string2));
    }

    public final void reinitialize() {
        this.m_aRWLock.writeLocked(this.m_aCountries::clear);
        ICommonsList<Locale> iCommonsList = LocaleCache.getInstance().getAllLocales();
        for (Locale locale : iCommonsList) {
            String string = locale.getCountry();
            if (!StringHelper.hasText(string)) continue;
            this.addCountry(string);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reinitialized " + this.getClass().getName());
        }
    }

    private static final class SingletonHolder {
        private static final CountryCache s_aInstance = new CountryCache();

        private SingletonHolder() {
        }
    }
}

