/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.system;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTFromString;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.system.SystemProperties;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Month;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class JavaVersionHelper {
    public static final double JAVA_CLASS_VERSION = StringParser.parseDouble(SystemProperties.getJavaClassVersion(), Double.NaN);
    public static final int JAVA_MAJOR_VERSION;
    public static final int JAVA_MINOR_VERSION;
    public static final int JAVA_MICRO_VERSION;
    private static final Logger LOGGER;
    private static final LocalDateTime REFERENCE_DATE;
    private static final LocalDateTime ADOPTOPENJDK_BUILD_172;
    private static final JavaVersionHelper s_aInstance;

    @Nonnull
    @ReturnsMutableCopy
    static int[] getAsUnifiedVersion(@Nonnull String string) {
        return JavaVersionHelper.getAsUnifiedVersion(string, SystemProperties.getJavaRuntimeVersion());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    @ReturnsMutableCopy
    static int[] getAsUnifiedVersion(@Nonnull String string, @Nullable String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string3 = string;
        if (string3.startsWith("1.")) {
            int n4 = (string3 = string3.substring(2)).indexOf(46);
            if (n4 < 0) {
                throw new IllegalStateException("Unexpected Java version string '" + string + "'");
            }
            n = StringParser.parseInt(string3.substring(0, n4), -1);
            if (n < 0) {
                throw new IllegalStateException("Failed to determine Java major version from '" + string + "'");
            }
            int n5 = string3.indexOf(95);
            if (n5 >= 0) {
                n2 = StringParser.parseInt(string3.substring(n5 + 1), -1);
                if (n2 < 0) {
                    throw new IllegalStateException("Failed to determine Java minor version from '" + string + "'");
                }
                n3 = -1;
            } else {
                int n6 = string3.indexOf(45);
                if (n6 < 0) throw new IllegalStateException("Unexpected Java version string '" + string + "'");
                if (string2.startsWith(string)) {
                    LocalDateTime localDateTime;
                    String string4 = string2.substring(string.length());
                    string4 = StringHelper.removeAll(string4, '_');
                    int n7 = (string4 = StringHelper.removeAll(string4, '-')).indexOf(98);
                    if (n7 >= 0) {
                        string4 = string4.substring(0, n7);
                    }
                    if ((localDateTime = PDTFromString.getLocalDateTimeFromString(string4, "uuuuMMddHHmm")) != null) {
                        n2 = localDateTime.equals(ADOPTOPENJDK_BUILD_172) ? 172 : Math.toIntExact(Duration.between(REFERENCE_DATE, localDateTime).toMinutes());
                    } else {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn("Unknown runtime version '" + string2 + "' compared to java version '" + string);
                        }
                        n2 = -1;
                        n3 = -1;
                    }
                } else {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Unknown runtime version '" + string2 + "' compared to java version '" + string);
                    }
                    n2 = -1;
                    n3 = -1;
                }
            }
        } else {
            int n8;
            int n9;
            int n10 = string3.indexOf(45);
            if (n10 > 0) {
                string3 = string3.substring(0, n10);
            }
            if ((n9 = string3.indexOf(43)) > 0) {
                string3 = string3.substring(0, n9);
            }
            if ((n = (n8 = string3.indexOf(46)) < 0 ? StringParser.parseInt(string3, -1) : StringParser.parseInt(string3.substring(0, n8), -1)) < 0) {
                throw new IllegalStateException("Failed to determine Java major version from '" + string + "'");
            }
            if (n8 >= 0) {
                int n11 = string3.indexOf(46, n8 + 1);
                n2 = n11 < 0 ? StringParser.parseInt(string3.substring(n8 + 1), -1) : StringParser.parseInt(string3.substring(n8 + 1, n11), -1);
                if (n2 < 0) {
                    throw new IllegalStateException("Failed to determine Java minor version from '" + string + "'");
                }
                if (n11 >= 0 && (n3 = StringParser.parseInt(string3.substring(n11 + 1), -1)) < 0) {
                    throw new IllegalStateException("Failed to determine Java micro version from '" + string + "'");
                }
            }
        }
        if (!LOGGER.isDebugEnabled()) return new int[]{n, n2, n3};
        LOGGER.debug("Java version '" + string + "' split into " + n + "." + n2 + (n3 >= 0 ? "." + n3 : ""));
        return new int[]{n, n2, n3};
    }

    private JavaVersionHelper() {
    }

    public static boolean isAtLeast(int n, int n2) {
        if (JAVA_MAJOR_VERSION > n) {
            return true;
        }
        if (JAVA_MAJOR_VERSION == n) {
            return JAVA_MINOR_VERSION >= n2;
        }
        return false;
    }

    static {
        LOGGER = LoggerFactory.getLogger(JavaVersionHelper.class);
        REFERENCE_DATE = PDTFactory.createLocalDateTime(2018, Month.JANUARY, 1, 0, 0, 0);
        ADOPTOPENJDK_BUILD_172 = PDTFactory.createLocalDateTime(2018, Month.MAY, 19, 0, 59, 0);
        int[] nArray = JavaVersionHelper.getAsUnifiedVersion(SystemProperties.getJavaVersion(), SystemProperties.getJavaRuntimeVersion());
        JAVA_MAJOR_VERSION = nArray[0];
        JAVA_MINOR_VERSION = nArray[1];
        JAVA_MICRO_VERSION = nArray[2];
        s_aInstance = new JavaVersionHelper();
    }
}

