/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.collection.impl.CommonsVector;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.serialize.SerializationHelper;
import com.helger.commons.string.StringHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CommonsTestHelper {
    private static final CommonsTestHelper s_aInstance = new CommonsTestHelper();

    private CommonsTestHelper() {
    }

    private static void _fail(@Nonnull String string) {
        throw new IllegalStateException(string);
    }

    private static void _assertTrue(@Nonnull String string, boolean bl) {
        if (!bl) {
            CommonsTestHelper._fail(string);
        }
    }

    private static void _assertFalse(@Nonnull String string, boolean bl) {
        if (bl) {
            CommonsTestHelper._fail(string);
        }
    }

    private static void _assertNotNull(@Nonnull String string, Object object) {
        if (object == null) {
            CommonsTestHelper._fail(string);
        }
    }

    public static <T> void _assertEquals(@Nonnull String string, @Nullable T t, @Nullable T t2) {
        if (!EqualsHelper.equals(t, t2)) {
            CommonsTestHelper._fail(string + "\nOBJ1: " + t + "\nOBJ2: " + t2);
        }
    }

    @SuppressFBWarnings(value={"EC_NULL_ARG"})
    private static <DATATYPE> void _testEqualsImplementation(@Nonnull DATATYPE DATATYPE) {
        CommonsTestHelper._assertNotNull("Passed object may not be null!", DATATYPE);
        CommonsTestHelper._assertTrue("Passed objects are not equal", DATATYPE.equals(DATATYPE));
        CommonsTestHelper._assertFalse("Object may no be equal to String", DATATYPE.equals("any string"));
        CommonsTestHelper._assertFalse("Object may no be equal to null", DATATYPE.equals(null));
    }

    public static <DATATYPE> void testEqualsImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testEqualsImplementation(DATATYPE);
        CommonsTestHelper._testEqualsImplementation(DATATYPE2);
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", EqualsHelper.identityEqual(DATATYPE, DATATYPE2));
        CommonsTestHelper._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertTrue("Passed objects are not identical!", DATATYPE2.equals(DATATYPE));
    }

    public static <DATATYPE> void testEqualsImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testEqualsImplementation(DATATYPE);
        CommonsTestHelper._testEqualsImplementation(DATATYPE2);
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", EqualsHelper.identityEqual(DATATYPE, DATATYPE2));
        CommonsTestHelper._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("Passed objects are identical!", DATATYPE2.equals(DATATYPE));
    }

    private static <DATATYPE> void _testHashcodeImplementation(@Nonnull DATATYPE DATATYPE) {
        CommonsTestHelper._assertNotNull("Passed object may not be null!", DATATYPE);
        CommonsTestHelper._assertTrue("hashCode() invocations must be consistent", DATATYPE.hashCode() == DATATYPE.hashCode());
        CommonsTestHelper._assertFalse("hashCode() may not be 0", DATATYPE.hashCode() == 0);
    }

    public static <DATATYPE> void testHashcodeImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testHashcodeImplementation(DATATYPE);
        CommonsTestHelper._testHashcodeImplementation(DATATYPE2);
        CommonsTestHelper._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        CommonsTestHelper._assertTrue("hashCode() invocations must be consistent", DATATYPE.hashCode() == DATATYPE2.hashCode());
        CommonsTestHelper._assertTrue("hashCode() invocations must be consistent", DATATYPE2.hashCode() == DATATYPE.hashCode());
    }

    public static <DATATYPE> void testHashcodeImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testHashcodeImplementation(DATATYPE);
        CommonsTestHelper._testHashcodeImplementation(DATATYPE2);
        CommonsTestHelper._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", EqualsHelper.identityEqual(DATATYPE, DATATYPE2));
        int n = DATATYPE.hashCode();
        int n2 = DATATYPE2.hashCode();
        CommonsTestHelper._assertFalse("hashCode() may not be the same for both objects", n == n2);
    }

    public static void testToStringImplementation(@Nonnull Object object) {
        CommonsTestHelper._assertNotNull("Passed object may not be null!", object);
        CommonsTestHelper._assertNotNull("toString() may not return null!", object.toString());
        CommonsTestHelper._assertTrue("toString() may not return an empty string!", object.toString().length() > 0);
        CommonsTestHelper._assertTrue("toString() invocations must be consistent", object.toString().equals(object.toString()));
    }

    public static <DATATYPE> void testToStringImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper.testToStringImplementation(DATATYPE);
        CommonsTestHelper.testToStringImplementation(DATATYPE2);
        CommonsTestHelper._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", EqualsHelper.identityEqual(DATATYPE, DATATYPE2));
    }

    public static <DATATYPE> void testToStringImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper.testToStringImplementation(DATATYPE);
        CommonsTestHelper.testToStringImplementation(DATATYPE2);
        CommonsTestHelper._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", EqualsHelper.identityEqual(DATATYPE, DATATYPE2));
    }

    public static <DATATYPE> void testDefaultImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper.testEqualsImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
        CommonsTestHelper.testHashcodeImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
        CommonsTestHelper.testToStringImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
    }

    public static <DATATYPE> void testDefaultImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper.testEqualsImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
        CommonsTestHelper.testHashcodeImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
        CommonsTestHelper.testToStringImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
    }

    @Nonnull
    public static <DATATYPE extends Serializable> DATATYPE testDefaultSerialization(@Nonnull DATATYPE DATATYPE) {
        byte[] byArray = SerializationHelper.getSerializedByteArray(DATATYPE);
        Serializable serializable = (Serializable)SerializationHelper.getDeserializedObject(byArray);
        CommonsTestHelper.testDefaultImplementationWithEqualContentObject(DATATYPE, serializable);
        return (DATATYPE)serializable;
    }

    public static void testGetClone(@Nonnull ICloneable<?> iCloneable) {
        Object obj = iCloneable.getClone();
        CommonsTestHelper._assertNotNull("Clone returned a null object", obj);
        CommonsTestHelper._assertTrue("Clone returned a different class than the original one", obj.getClass().equals(iCloneable.getClass()));
        CommonsTestHelper.testDefaultImplementationWithEqualContentObject(iCloneable, obj);
    }

    public static void testClone(@Nonnull IExplicitlyCloneable iExplicitlyCloneable) {
        try {
            Object object = iExplicitlyCloneable.clone();
            CommonsTestHelper._assertNotNull("Clone returned a null object", object);
            CommonsTestHelper._assertTrue("Clone returned a different class than the original one", object.getClass().equals(iExplicitlyCloneable.getClass()));
            CommonsTestHelper.testDefaultImplementationWithEqualContentObject(iExplicitlyCloneable, object);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }

    public static void testInParallel(@Nonnegative int n, @Nonnull IThrowingRunnable<? extends Exception> iThrowingRunnable) {
        ValueEnforcer.isGE0(n, "Calls");
        ValueEnforcer.notNull(iThrowingRunnable, "Runnable");
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        CommonsVector commonsVector = new CommonsVector();
        for (int i = 0; i < n; ++i) {
            executorService.submit(() -> {
                try {
                    iThrowingRunnable.run();
                }
                catch (Exception exception) {
                    commonsVector.add(exception.getMessage() + "\n" + StackTraceHelper.getStackAsString(exception));
                }
            });
        }
        ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished(executorService);
        if (!commonsVector.isEmpty()) {
            CommonsTestHelper._fail(StringHelper.getImploded(commonsVector));
        }
    }
}

