/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.serialize.convert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.serialize.convert.ISerializationConverter;
import com.helger.commons.serialize.convert.ISerializationConverterCallback;
import com.helger.commons.serialize.convert.ISerializationConverterRegistrarSPI;
import com.helger.commons.serialize.convert.ISerializationConverterRegistry;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SerializationConverterRegistry
implements ISerializationConverterRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationConverterRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<Class<?>, ISerializationConverter<?>> m_aMap = new CommonsHashMap();

    private SerializationConverterRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static SerializationConverterRegistry getInstance() {
        SerializationConverterRegistry serializationConverterRegistry = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return serializationConverterRegistry;
    }

    @Override
    public <T> void registerSerializationConverter(@Nonnull Class<T> clazz, @Nonnull ISerializationConverter<T> iSerializationConverter) {
        ValueEnforcer.notNull(clazz, "Class");
        ValueEnforcer.notNull(iSerializationConverter, "Converter");
        ValueEnforcer.isFalse(Serializable.class.isAssignableFrom(clazz), () -> "The provided " + clazz.toString() + " is already implementing Serializable!");
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey(clazz)) {
                throw new IllegalArgumentException("A micro type converter for class " + clazz + " is already registered!");
            }
            for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                Class clazz2 = (Class)weakReference.get();
                if (clazz2 == null || this.m_aMap.containsKey(clazz2)) continue;
                this.m_aMap.put(clazz2, iSerializationConverter);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Registered serialization converter for '" + clazz2.toString() + "'");
            }
        });
    }

    @Nullable
    public <T> ISerializationConverter<T> getConverter(@Nullable Class<T> clazz) {
        return this.m_aRWLock.readLockedGet(() -> {
            ISerializationConverter iSerializationConverter = (ISerializationConverter)this.m_aMap.get(clazz);
            if (iSerializationConverter == null) {
                for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                    Class clazz2 = (Class)weakReference.get();
                    if (clazz2 == null || (iSerializationConverter = (ISerializationConverter)this.m_aMap.get(clazz2)) == null) continue;
                    if (!LOGGER.isDebugEnabled()) break;
                    LOGGER.debug("Using serialization converter " + iSerializationConverter + " for class " + clazz + " based on " + clazz2);
                    break;
                }
            }
            return (ISerializationConverter)GenericReflection.uncheckedCast(iSerializationConverter);
        });
    }

    public void iterateAllRegisteredSerializationConverters(@Nonnull ISerializationConverterCallback iSerializationConverterCallback) {
        Map map = this.m_aRWLock.readLockedGet(() -> new CommonsHashMap((Map<Class<?>, ISerializationConverter<?>>)this.m_aMap));
        for (Map.Entry entry : map.entrySet()) {
            if (iSerializationConverterCallback.call((Class)entry.getKey(), (ISerializationConverter)entry.getValue()).isBreak()) break;
        }
    }

    @Nonnegative
    public int getRegisteredSerializationConverterCount() {
        return this.m_aRWLock.readLockedInt(this.m_aMap::size);
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(this.m_aMap::clear);
        for (ISerializationConverterRegistrarSPI iSerializationConverterRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(ISerializationConverterRegistrarSPI.class)) {
            iSerializationConverterRegistrarSPI.registerSerializationConverter(this);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.getRegisteredSerializationConverterCount() + " serialization converters registered");
        }
    }

    private static final class SingletonHolder {
        private static final SerializationConverterRegistry s_aInstance = new SerializationConverterRegistry();

        private SingletonHolder() {
        }
    }
}

