/* ParserCSS21.java */
/* Generated By:JJTree&JavaCC: Do not edit this line. ParserCSS21.java */
package com.helger.css.parser;

public class ParserCSS21 extends com.helger.css.parser.AbstractParserCSS/*@bgen(jjtree)*/implements ParserCSS21TreeConstants, ParserCSS21Constants {/*@bgen(jjtree)*/
  protected JJTParserCSS21State jjtree = new JJTParserCSS21State();private static final org.slf4j.Logger s_aLogger = org.slf4j.LoggerFactory.getLogger (ParserCSS21.class);

  // Used when NODE_SCOPE_HOOK is true - for debugging only
  // Package scope to avoid warning when NODE_SCOPE_HOOK is false
  void jjtreeOpenNodeScope (final Node aNode)
  {
    if (s_aLogger.isDebugEnabled ())
      s_aLogger.debug ("Opening scope for " + aNode.toString ());
  }

  void jjtreeCloseNodeScope (final Node aNode)
  {
    if (s_aLogger.isDebugEnabled ())
      s_aLogger.debug ("Closing scope for " + aNode.toString ());
  }

  private void errorUnexpectedRule(final String sRule, final String sMsg) throws ParseException {if (m_aCustomErrorHandler != null)
    m_aCustomErrorHandler.onCSSUnexpectedRule (token, sRule, sMsg);
  else
    s_aLogger.warn("[" + token.beginLine + ":" + token.beginColumn + "] Unexpected rule '" + sRule + "': " + sMsg);
  }

  private Token errorSkipTo(final ParseException ex, final int... aKinds) throws ParseException, ParseException {/*@bgen(jjtree) errorSkipTo */
com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTERRORSKIPTO);
boolean jjtc000 = true;
jjtree.openNodeScope(jjtn000);
jjtn000.jjtSetFirstToken(getToken(1));
try {// Skip until (including) the first matching token
  Token tok;
  do
  {
    tok = getNextToken();
    if (tok.kind == EOF)
    {
      // Encountered EOF while skipping - throw the original exception!
      throw ex;
    }
  } while (!com.helger.commons.collection.ArrayHelper.contains (aKinds, tok.kind));

  if (s_aLogger.isDebugEnabled ())
    s_aLogger.debug ("Skipped until token " + tok.toString ());

  if (m_aCustomErrorHandler != null)
    m_aCustomErrorHandler.onCSSParseError (ex.currentToken, ex.expectedTokenSequences, ex.tokenImage, tok);
  else
    s_aLogger.warn("CSS recoverable parse error", ex);
  return tok;/*@bgen(jjtree)*/
} catch (Throwable jjte000) {
  if (jjtc000) {
    jjtree.clearNodeScope(jjtn000);
    jjtc000 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte000 instanceof ParseException) {
    throw (ParseException)jjte000;
  }
  throw (Error)jjte000;
} finally {
  if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true);
    jjtn000.jjtSetLastToken(getToken(0));
  }
}
  }

  private String javaSkipToClosingParantheses() throws ParseException, ParseException {final StringBuilder aSB = new StringBuilder ();
  int nNesting = 1;
  while (true) {
    final Token tok = getNextToken();
    aSB.append (tok.image);
    if (tok.kind == LROUND)
      nNesting++;
    else
      if (tok.kind == RROUND) {
        nNesting--;
        if (nNesting == 0)
          break;
      }
      else {
        if (tok.kind == EOF)
          throw new ParseEOFException ("EOF while searching for matching closing ')'.");
        // Sometimes token images contain parenthesis
        nNesting += com.helger.commons.string.StringHelper.getCharCount (tok.image, '(');
        nNesting -= com.helger.commons.string.StringHelper.getCharCount (tok.image, ')');
      }
  }
  return aSB.toString ();
  }

  private String javaSkipToOpeningBrace() throws ParseException, ParseException {final StringBuilder aSB = new StringBuilder ();
  Token tok;
  while (true) {
    tok = getNextToken();
    if (tok.kind == EOF)
      throw new ParseEOFException ("EOF while searching for opening '{'.");
    if (tok.kind == LBRACE)
      break;
    aSB.append (tok.image);
  }
  return aSB.toString ();
  }

  private String javaSkipToClosingBrace(final int nInitialNesting) throws ParseException, ParseEOFException {final StringBuilder aSB = new StringBuilder ();
  int nNesting = nInitialNesting;
  while (true) {
    final Token tok = getNextToken();
    if (tok.kind == LBRACE)
      nNesting++;
    else
      if (tok.kind == RBRACE) {
        nNesting--;
        if (nNesting == 0)
          break;
      }
      else {
        if (tok.kind == EOF)
          throw new ParseEOFException ("EOF while searching for matching closing '}'.");
        // Token images never contain brackets
      }
    aSB.append (tok.image);
  }
  // System.out.println ("SKIP-TO-} -- '" + aSB + "'");
  return aSB.toString ();
  }

  private String javaSkipToClosingBraceOrSemicolon(final int nInitialNesting) throws ParseException, ParseEOFException {final StringBuilder aSB = new StringBuilder ();
  int nNesting = nInitialNesting;
  while (true) {
    final Token tok = getNextToken();
    if (tok.kind == LBRACE)
      nNesting++;
    else
      if (tok.kind == RBRACE) {
        nNesting--;
        if (nNesting == 0)
          break;
      }
      else
        if (tok.kind == SEMICOLON) {
          if (nNesting == 1)
            break;
        }
        else {
          if (tok.kind == EOF)
            throw new ParseEOFException ("EOF while searching for matching closing '}' or ';'.");
          // Token images never contain brackets
        }
    aSB.append (tok.image);
  }
  // System.out.println ("SKIP-TO-}; -- '" + aSB + "'");
  return aSB.toString ();
  }

  private void browserCompliantSkip() throws ParseException, ParseEOFException {javaSkipToClosingBrace (1);
  // push back last token!
  token_source.backup(1);
  }

  private void browserCompliantSkipSelector() throws ParseException, ParseEOFException {javaSkipToClosingBrace (0);
  // push back last token!
  token_source.backup(1);
  }

  private void browserCompliantSkipDecl() throws ParseException, ParseEOFException {javaSkipToClosingBraceOrSemicolon (1);
  // push back last token!
  token_source.backup(1);
  }

//
// whole stylesheet
//
  final public CSSNode styleSheet() throws ParseException {/*@bgen(jjtree) Root */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTROOT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      try {
        label_1:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:
          case CDO:
          case CDC:{
            ;
            break;
            }
          default:
            jj_la1[0] = jj_gen;
            break label_1;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            jj_consume_token(S);
            break;
            }
          case CDO:{
            jj_consume_token(CDO);
            break;
            }
          case CDC:{
            jj_consume_token(CDC);
            break;
            }
          default:
            jj_la1[1] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        if (jj_2_1(2147483647)) {
          charsetRule();
          label_2:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:
            case CDO:
            case CDC:{
              ;
              break;
              }
            default:
              jj_la1[2] = jj_gen;
              break label_2;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              jj_consume_token(S);
              break;
              }
            case CDO:{
              jj_consume_token(CDO);
              break;
              }
            case CDC:{
              jj_consume_token(CDC);
              break;
              }
            default:
              jj_la1[3] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        } else {
          ;
        }
        label_3:
        while (true) {
          if (jj_2_2(2147483647)) {
            ;
          } else {
            break label_3;
          }
          importRule();
          label_4:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:
            case CDO:
            case CDC:{
              ;
              break;
              }
            default:
              jj_la1[4] = jj_gen;
              break label_4;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              jj_consume_token(S);
              break;
              }
            case CDO:{
              jj_consume_token(CDO);
              break;
              }
            case CDC:{
              jj_consume_token(CDC);
              break;
              }
            default:
              jj_la1[5] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        label_5:
        while (true) {
          if (jj_2_3(2147483647)) {
            ;
          } else {
            break label_5;
          }
          namespaceRule();
          label_6:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:
            case CDO:
            case CDC:{
              ;
              break;
              }
            default:
              jj_la1[6] = jj_gen;
              break label_6;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              jj_consume_token(S);
              break;
              }
            case CDO:{
              jj_consume_token(CDO);
              break;
              }
            case CDC:{
              jj_consume_token(CDC);
              break;
              }
            default:
              jj_la1[7] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        label_7:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LSQUARE:
          case DOT:
          case COLON:
          case ASTERISK:
          case DASH:
          case HASH:
          case CHARSET_SYM:
          case IMPORT_SYM:
          case NAMESPACE_SYM:
          case PAGE_SYM:
          case MEDIA_SYM:
          case AT_UNKNOWN:
          case IDENT:{
            ;
            break;
            }
          default:
            jj_la1[8] = jj_gen;
            break label_7;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LSQUARE:
          case DOT:
          case COLON:
          case ASTERISK:
          case DASH:
          case HASH:
          case IDENT:{
            styleRule();
            break;
            }
          case MEDIA_SYM:{
            mediaRule();
            break;
            }
          case PAGE_SYM:{
            pageRule();
            break;
            }
          case AT_UNKNOWN:{
            unknownRule();
            break;
            }
          case CHARSET_SYM:{
            charsetRule();
errorUnexpectedRule ("@charset", "charset rule in the middle of the file is not allowed!");
            break;
            }
          case IMPORT_SYM:{
            importRule();
errorUnexpectedRule ("@import", "import rule in the middle of the file is not allowed!");
            break;
            }
          case NAMESPACE_SYM:{
            namespaceRule();
errorUnexpectedRule ("@namespace", "namespace rule in the middle of the file is not allowed!");
            break;
            }
          default:
            jj_la1[9] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_8:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:
            case CDO:
            case CDC:{
              ;
              break;
              }
            default:
              jj_la1[10] = jj_gen;
              break label_8;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              jj_consume_token(S);
              break;
              }
            case CDO:{
              jj_consume_token(CDO);
              break;
              }
            case CDC:{
              jj_consume_token(CDC);
              break;
              }
            default:
              jj_la1[11] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          label_9:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case RBRACE:{
              ;
              break;
              }
            default:
              jj_la1[12] = jj_gen;
              break label_9;
            }
            jj_consume_token(RBRACE);
            label_10:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:
              case CDO:
              case CDC:{
                ;
                break;
                }
              default:
                jj_la1[13] = jj_gen;
                break label_10;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S:{
                jj_consume_token(S);
                break;
                }
              case CDO:{
                jj_consume_token(CDO);
                break;
                }
              case CDC:{
                jj_consume_token(CDC);
                break;
                }
              default:
                jj_la1[14] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
        jj_consume_token(0);
      } catch (ParseEOFException ex) {
if (m_bBrowserCompliantMode) {
    /* ignore special EOF excpetion */
  }
  else
    {if (true) throw ex;}
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
{if ("" != null) return jjtn000;}
    } catch (Throwable jjte000) {
if (jjtc000) {
    jjtree.clearNodeScope(jjtn000);
    jjtc000 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte000 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte000;}
  }
  if (jjte000 instanceof ParseException) {
    {if (true) throw (ParseException)jjte000;}
  }
  {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true);
    jjtn000.jjtSetLastToken(getToken(0));
  }
    }
    throw new Error("Missing return statement in function");
  }

//
// Generic utility rules
//
  final public String string() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING1:{
      jj_consume_token(STRING1);
{if ("" != null) return token.image;}
      break;
      }
    case STRING2:{
      jj_consume_token(STRING2);
{if ("" != null) return token.image;}
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String anyIdentifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      jj_consume_token(IDENT);
{if ("" != null) return token.image;}
      break;
      }
    case INHERIT:{
      jj_consume_token(INHERIT);
{if ("" != null) return token.image;}
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void url() throws ParseException {/*@bgen(jjtree) url */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTURL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(URL);
jjtree.closeNodeScope(jjtn000, true);
           jjtc000 = false;
           jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (token.image);
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void function() throws ParseException {/*@bgen(jjtree) function */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTFUNCTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String sPlain;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FUNCTION:{
        jj_consume_token(FUNCTION);
jjtn000.setText (token.image + ")");
        label_11:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[17] = jj_gen;
            break label_11;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case STRING1:
        case STRING2:
        case NUMBER:
        case MINUS:
        case PLUS:
        case HASH:
        case INHERIT:
        case IDENT:
        case EM:
        case EX:
        case PX:
        case LENGTH_CM:
        case LENGTH_MM:
        case LENGTH_IN:
        case LENGTH_PT:
        case LENGTH_PC:
        case ANGLE_DEG:
        case ANGLE_RAD:
        case ANGLE_GRAD:
        case TIME_MS:
        case TIME_S:
        case FREQ_HZ:
        case FREQ_KHZ:
        case PERCENTAGE:
        case DIMENSION:
        case URL:
        case FUNCTION_EXPRESSION:
        case FUNCTION:{
          expr();
          break;
          }
        default:
          jj_la1[18] = jj_gen;
          ;
        }
        jj_consume_token(RROUND);
        break;
        }
      case FUNCTION_EXPRESSION:{
        jj_consume_token(FUNCTION_EXPRESSION);
jjtn000.setText (token.image);
        // get content of all skipped chars 
            sPlain = javaSkipToClosingParantheses();
jjtree.closeNodeScope(jjtn000, true);
                                              jjtc000 = false;
                                              jjtn000.jjtSetLastToken(getToken(0));
jjtn000.appendText (sPlain);
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public String unaryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:{
      jj_consume_token(MINUS);
{if ("" != null) return "-";}
      break;
      }
    case PLUS:{
      jj_consume_token(PLUS);
{if ("" != null) return "+";}
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Token dimension() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EM:{
      t = jj_consume_token(EM);
      break;
      }
    case EX:{
      t = jj_consume_token(EX);
      break;
      }
    case PX:{
      t = jj_consume_token(PX);
      break;
      }
    case LENGTH_CM:{
      t = jj_consume_token(LENGTH_CM);
      break;
      }
    case LENGTH_MM:{
      t = jj_consume_token(LENGTH_MM);
      break;
      }
    case LENGTH_IN:{
      t = jj_consume_token(LENGTH_IN);
      break;
      }
    case LENGTH_PT:{
      t = jj_consume_token(LENGTH_PT);
      break;
      }
    case LENGTH_PC:{
      t = jj_consume_token(LENGTH_PC);
      break;
      }
    case ANGLE_DEG:{
      t = jj_consume_token(ANGLE_DEG);
      break;
      }
    case ANGLE_RAD:{
      t = jj_consume_token(ANGLE_RAD);
      break;
      }
    case ANGLE_GRAD:{
      t = jj_consume_token(ANGLE_GRAD);
      break;
      }
    case TIME_MS:{
      t = jj_consume_token(TIME_MS);
      break;
      }
    case TIME_S:{
      t = jj_consume_token(TIME_S);
      break;
      }
    case FREQ_HZ:{
      t = jj_consume_token(FREQ_HZ);
      break;
      }
    case FREQ_KHZ:{
      t = jj_consume_token(FREQ_KHZ);
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
  }

  final public void exprTerm() throws ParseException {/*@bgen(jjtree) exprTerm */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTEXPRTERM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String sPrefix = null;
  Token t = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:
      case MINUS:
      case PLUS:
      case EM:
      case EX:
      case PX:
      case LENGTH_CM:
      case LENGTH_MM:
      case LENGTH_IN:
      case LENGTH_PT:
      case LENGTH_PC:
      case ANGLE_DEG:
      case ANGLE_RAD:
      case ANGLE_GRAD:
      case TIME_MS:
      case TIME_S:
      case FREQ_HZ:
      case FREQ_KHZ:
      case PERCENTAGE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case MINUS:
        case PLUS:{
          sPrefix = unaryOperator();
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NUMBER:{
          t = jj_consume_token(NUMBER);
          break;
          }
        case PERCENTAGE:{
          t = jj_consume_token(PERCENTAGE);
          break;
          }
        case EM:
        case EX:
        case PX:
        case LENGTH_CM:
        case LENGTH_MM:
        case LENGTH_IN:
        case LENGTH_PT:
        case LENGTH_PC:
        case ANGLE_DEG:
        case ANGLE_RAD:
        case ANGLE_GRAD:
        case TIME_MS:
        case TIME_S:
        case FREQ_HZ:
        case FREQ_KHZ:{
          t = dimension();
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case STRING1:
      case STRING2:{
        sPrefix = string();
        break;
        }
      case IDENT:{
        t = jj_consume_token(IDENT);
        break;
        }
      case URL:{
        url();
        break;
        }
      case HASH:{
        t = jj_consume_token(HASH);
        break;
        }
      case FUNCTION_EXPRESSION:
      case FUNCTION:{
        function();
        break;
        }
      case DIMENSION:{
        t = jj_consume_token(DIMENSION);
        break;
        }
      case INHERIT:{
        t = jj_consume_token(INHERIT);
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[25] = jj_gen;
          break label_12;
        }
        jj_consume_token(S);
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
if (sPrefix != null)
      jjtn000.appendText (sPrefix);
    if (t != null)
      jjtn000.appendText (t.image);
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void exprOperator() throws ParseException {/*@bgen(jjtree) exprOperator */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTEXPROPERATOR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SLASH:{
        jj_consume_token(SLASH);
        label_13:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[26] = jj_gen;
            break label_13;
          }
          jj_consume_token(S);
        }
jjtree.closeNodeScope(jjtn000, true);
                        jjtc000 = false;
                        jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText ("/");
        break;
        }
      case COMMA:{
        jj_consume_token(COMMA);
        label_14:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[27] = jj_gen;
            break label_14;
          }
          jj_consume_token(S);
        }
jjtree.closeNodeScope(jjtn000, true);
                        jjtc000 = false;
                        jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (",");
        break;
        }
      case EQUALS:{
        jj_consume_token(EQUALS);
        label_15:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[28] = jj_gen;
            break label_15;
          }
          jj_consume_token(S);
        }
jjtree.closeNodeScope(jjtn000, true);
                        jjtc000 = false;
                        jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText ("=");
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void expr() throws ParseException {/*@bgen(jjtree) expr */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTEXPR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      exprTerm();
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case STRING1:
        case STRING2:
        case NUMBER:
        case COMMA:
        case SLASH:
        case MINUS:
        case EQUALS:
        case PLUS:
        case HASH:
        case INHERIT:
        case IDENT:
        case EM:
        case EX:
        case PX:
        case LENGTH_CM:
        case LENGTH_MM:
        case LENGTH_IN:
        case LENGTH_PT:
        case LENGTH_PC:
        case ANGLE_DEG:
        case ANGLE_RAD:
        case ANGLE_GRAD:
        case TIME_MS:
        case TIME_S:
        case FREQ_HZ:
        case FREQ_KHZ:
        case PERCENTAGE:
        case DIMENSION:
        case URL:
        case FUNCTION_EXPRESSION:
        case FUNCTION:{
          ;
          break;
          }
        default:
          jj_la1[30] = jj_gen;
          break label_16;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:
        case SLASH:
        case EQUALS:{
          exprOperator();
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          ;
        }
        exprTerm();
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

//
// Charset rule
//
  final public void charsetRule() throws ParseException {/*@bgen(jjtree) charsetRule */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTCHARSETRULE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String sStr;
    try {
      jj_consume_token(CHARSET_SYM);
      label_17:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[32] = jj_gen;
          break label_17;
        }
      }
      sStr = string();
jjtn000.setText (sStr);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[33] = jj_gen;
          break label_18;
        }
        jj_consume_token(S);
      }
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

//
// Import rule
//
  final public void importRule() throws ParseException {/*@bgen(jjtree) importRule */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTIMPORTRULE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String sUrl;
    try {
      jj_consume_token(IMPORT_SYM);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[34] = jj_gen;
          break label_19;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING1:
      case STRING2:{
        sUrl = string();
jjtn000.setText (sUrl);
        break;
        }
      case URL:{
        url();
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[36] = jj_gen;
          break label_20;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        mediaList();
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

//
// Namespace rule
//
  final public void namespaceRulePrefix() throws ParseException {/*@bgen(jjtree) namespaceRulePrefix */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTNAMESPACERULEPREFIX);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(IDENT);
jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (token.image);
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void namespaceRuleURL() throws ParseException {/*@bgen(jjtree) namespaceRuleURL */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTNAMESPACERULEURL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String s;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case URL:{
        jj_consume_token(URL);
jjtree.closeNodeScope(jjtn000, true);
                   jjtc000 = false;
                   jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (token.image);
        break;
        }
      case STRING1:
      case STRING2:{
        s = string();
jjtree.closeNodeScope(jjtn000, true);
                   jjtc000 = false;
                   jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (CSSParseHelper.unescapeURL (s));
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void namespaceRule() throws ParseException {/*@bgen(jjtree) namespaceRule */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTNAMESPACERULE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(NAMESPACE_SYM);
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[39] = jj_gen;
          break label_21;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        namespaceRulePrefix();
        label_22:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[40] = jj_gen;
            break label_22;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      namespaceRuleURL();
      label_23:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[42] = jj_gen;
          break label_23;
        }
        jj_consume_token(S);
      }
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

//
// Style rule
//
  final public void namespacePrefix() throws ParseException {/*@bgen(jjtree) namespacePrefix */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTNAMESPACEPREFIX);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASTERISK:
      case IDENT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENT:{
          jj_consume_token(IDENT);
jjtn000.setText (token.image);
          break;
          }
        case ASTERISK:{
          jj_consume_token(ASTERISK);
jjtn000.setText (token.image);
          break;
          }
        default:
          jj_la1[43] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      jj_consume_token(DASH);
jjtree.closeNodeScope(jjtn000, true);
                  jjtc000 = false;
                  jjtn000.jjtSetLastToken(getToken(0));
jjtn000.appendText ("|");
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void elementName() throws ParseException {/*@bgen(jjtree) elementName */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTELEMENTNAME);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        jj_consume_token(IDENT);
jjtree.closeNodeScope(jjtn000, true);
                 jjtc000 = false;
                 jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (token.image);
        break;
        }
      case ASTERISK:{
        jj_consume_token(ASTERISK);
jjtree.closeNodeScope(jjtn000, true);
                 jjtc000 = false;
                 jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (token.image);
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void typeSelector() throws ParseException {
    if (jj_2_4(2)) {
      namespacePrefix();
    } else {
      ;
    }
    elementName();
  }

  final public void hash() throws ParseException {/*@bgen(jjtree) hash */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTHASH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(HASH);
jjtree.closeNodeScope(jjtn000, true);
           jjtc000 = false;
           jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (token.image);
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void _class() throws ParseException {/*@bgen(jjtree) Class */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTCLASS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String sIdentifier;
    try {
      jj_consume_token(DOT);
      sIdentifier = anyIdentifier();
jjtree.closeNodeScope(jjtn000, true);
                                  jjtc000 = false;
                                  jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText ("." + sIdentifier);
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void attribOperator() throws ParseException {/*@bgen(jjtree) attribOperator */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTATTRIBOPERATOR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQUALS:{
        jj_consume_token(EQUALS);
jjtree.closeNodeScope(jjtn000, true);
                       jjtc000 = false;
                       jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText ("=");
        break;
        }
      case INCLUDES:{
        jj_consume_token(INCLUDES);
jjtree.closeNodeScope(jjtn000, true);
                       jjtc000 = false;
                       jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText ("~=");
        break;
        }
      case DASHMATCH:{
        jj_consume_token(DASHMATCH);
jjtree.closeNodeScope(jjtn000, true);
                       jjtc000 = false;
                       jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText ("|=");
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void attribValue() throws ParseException {/*@bgen(jjtree) attribValue */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTATTRIBVALUE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String sStr;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        jj_consume_token(IDENT);
jjtree.closeNodeScope(jjtn000, true);
                      jjtc000 = false;
                      jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (token.image);
        break;
        }
      case STRING1:
      case STRING2:{
        sStr = string();
jjtree.closeNodeScope(jjtn000, true);
                      jjtc000 = false;
                      jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (sStr);
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void attrib() throws ParseException {/*@bgen(jjtree) attrib */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTATTRIB);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LSQUARE);
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[48] = jj_gen;
          break label_24;
        }
        jj_consume_token(S);
      }
      if (jj_2_5(2)) {
        namespacePrefix();
      } else {
        ;
      }
      jj_consume_token(IDENT);
jjtn000.setText (token.image);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASTERISK:{
        jj_consume_token(ASTERISK);
jjtn000.appendText ("*");
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        ;
      }
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[50] = jj_gen;
          break label_25;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQUALS:
      case INCLUDES:
      case DASHMATCH:{
        attribOperator();
        label_26:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[51] = jj_gen;
            break label_26;
          }
          jj_consume_token(S);
        }
        attribValue();
        label_27:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[52] = jj_gen;
            break label_27;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[53] = jj_gen;
        ;
      }
      jj_consume_token(RSQUARE);
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void pseudo() throws ParseException {/*@bgen(jjtree) pseudo */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTPSEUDO);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(COLON);
jjtn000.setText (":");
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
jjtn000.appendText (":");
        break;
        }
      default:
        jj_la1[54] = jj_gen;
        ;
      }
      if (jj_2_6(2)) {
        jj_consume_token(FUNCTION);
jjtn000.appendText (token.image);
        label_28:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[55] = jj_gen;
            break label_28;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case STRING1:
        case STRING2:
        case NUMBER:
        case MINUS:
        case PLUS:
        case HASH:
        case INHERIT:
        case IDENT:
        case EM:
        case EX:
        case PX:
        case LENGTH_CM:
        case LENGTH_MM:
        case LENGTH_IN:
        case LENGTH_PT:
        case LENGTH_PC:
        case ANGLE_DEG:
        case ANGLE_RAD:
        case ANGLE_GRAD:
        case TIME_MS:
        case TIME_S:
        case FREQ_HZ:
        case FREQ_KHZ:
        case PERCENTAGE:
        case DIMENSION:
        case URL:
        case FUNCTION_EXPRESSION:
        case FUNCTION:{
          expr();
          break;
          }
        default:
          jj_la1[56] = jj_gen;
          ;
        }
        jj_consume_token(RROUND);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENT:{
          jj_consume_token(IDENT);
jjtree.closeNodeScope(jjtn000, true);
              jjtc000 = false;
              jjtn000.jjtSetLastToken(getToken(0));
jjtn000.appendText (token.image);
          break;
          }
        default:
          jj_la1[57] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void simpleSelectorSequence() throws ParseException {
    if (jj_2_7(2)) {
      typeSelector();
      label_29:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LSQUARE:
        case DOT:
        case COLON:
        case HASH:{
          ;
          break;
          }
        default:
          jj_la1[58] = jj_gen;
          break label_29;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASH:{
          hash();
          break;
          }
        case DOT:{
          _class();
          break;
          }
        case LSQUARE:{
          attrib();
          break;
          }
        case COLON:{
          pseudo();
          break;
          }
        default:
          jj_la1[59] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LSQUARE:
      case DOT:
      case COLON:
      case HASH:{
        label_30:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case HASH:{
            hash();
            break;
            }
          case DOT:{
            _class();
            break;
            }
          case LSQUARE:{
            attrib();
            break;
            }
          case COLON:{
            pseudo();
            break;
            }
          default:
            jj_la1[60] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LSQUARE:
          case DOT:
          case COLON:
          case HASH:{
            ;
            break;
            }
          default:
            jj_la1[61] = jj_gen;
            break label_30;
          }
        }
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void selectorCombinator() throws ParseException {/*@bgen(jjtree) selectorCombinator */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTSELECTORCOMBINATOR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (jj_2_8(2)) {
        label_31:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[63] = jj_gen;
            break label_31;
          }
          jj_consume_token(S);
        }
        jj_consume_token(PLUS);
jjtree.closeNodeScope(jjtn000, true);
                   jjtc000 = false;
                   jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText ("+");
      } else if (jj_2_9(2)) {
        label_32:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[64] = jj_gen;
            break label_32;
          }
          jj_consume_token(S);
        }
        jj_consume_token(GREATER);
jjtree.closeNodeScope(jjtn000, true);
                   jjtc000 = false;
                   jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (">");
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          jj_consume_token(S);
jjtree.closeNodeScope(jjtn000, true);
                   jjtc000 = false;
                   jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (" ");
          break;
          }
        default:
          jj_la1[65] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void selector() throws ParseException {/*@bgen(jjtree) selector */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTSELECTOR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      simpleSelectorSequence();
      label_33:
      while (true) {
        if (jj_2_10(3)) {
          ;
        } else {
          break label_33;
        }
        selectorCombinator();
        label_34:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[66] = jj_gen;
            break label_34;
          }
          jj_consume_token(S);
        }
        simpleSelectorSequence();
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void property() throws ParseException {/*@bgen(jjtree) property */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTPROPERTY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(IDENT);
jjtn000.setText (token.image);
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[67] = jj_gen;
          break label_35;
        }
        jj_consume_token(S);
      }
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void important() throws ParseException {/*@bgen(jjtree) important */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTIMPORTANT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(IMPORTANT_SYM);
jjtn000.setText (token.image);
      label_36:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[68] = jj_gen;
          break label_36;
        }
        jj_consume_token(S);
      }
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void styleDeclaration() throws ParseException {/*@bgen(jjtree) styleDeclaration */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTSTYLEDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      try {
        property();
        jj_consume_token(COLON);
        label_37:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[69] = jj_gen;
            break label_37;
          }
          jj_consume_token(S);
        }
        expr();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IMPORTANT_SYM:{
          important();
          break;
          }
        default:
          jj_la1[70] = jj_gen;
          ;
        }
      } catch (ParseException ex) {
if (m_bBrowserCompliantMode)
    browserCompliantSkipDecl ();
  else
    {if (true) throw ex;}
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
    jjtree.clearNodeScope(jjtn000);
    jjtc000 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte000 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte000;}
  }
  if (jjte000 instanceof ParseException) {
    {if (true) throw (ParseException)jjte000;}
  }
  {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true);
    jjtn000.jjtSetLastToken(getToken(0));
  }
    }
  }

  final public CSSNode styleDeclarationList() throws ParseException {/*@bgen(jjtree) styleDeclarationList */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTSTYLEDECLARATIONLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      label_38:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[71] = jj_gen;
          break label_38;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        styleDeclaration();
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        ;
      }
      label_39:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[73] = jj_gen;
          break label_39;
        }
        jj_consume_token(SEMICOLON);
        label_40:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[74] = jj_gen;
            break label_40;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENT:{
          styleDeclaration();
          break;
          }
        default:
          jj_la1[75] = jj_gen;
          ;
        }
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
{if ("" != null) return jjtn000;}
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new Error("Missing return statement in function");
  }

  final public void styleDeclarationBlock() throws ParseException {
    jj_consume_token(LBRACE);
    try {
      styleDeclarationList();
      jj_consume_token(RBRACE);
    } catch (ParseException ex) {
if (m_bBrowserCompliantMode)
    browserCompliantSkip ();
  else
    errorSkipTo (ex, RBRACE);
    }
  }

  final public void styleRule() throws ParseException {/*@bgen(jjtree) styleRule */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTSTYLERULE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      try {
        selector();
        label_41:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[76] = jj_gen;
            break label_41;
          }
          jj_consume_token(S);
        }
        label_42:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[77] = jj_gen;
            break label_42;
          }
          jj_consume_token(COMMA);
          label_43:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[78] = jj_gen;
              break label_43;
            }
            jj_consume_token(S);
          }
          selector();
          label_44:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[79] = jj_gen;
              break label_44;
            }
            jj_consume_token(S);
          }
        }
        styleDeclarationBlock();
      } catch (ParseException ex) {
if (m_bBrowserCompliantMode)
    browserCompliantSkipSelector ();
  else
    {if (true) throw ex;}
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
    jjtree.clearNodeScope(jjtn000);
    jjtc000 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte000 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte000;}
  }
  if (jjte000 instanceof ParseException) {
    {if (true) throw (ParseException)jjte000;}
  }
  {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true);
    jjtn000.jjtSetLastToken(getToken(0));
  }
    }
  }

//
// Media rule
//
  final public void medium() throws ParseException {/*@bgen(jjtree) medium */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTMEDIUM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(IDENT);
jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (token.image);
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void mediaList() throws ParseException {/*@bgen(jjtree) mediaList */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTMEDIALIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      medium();
      label_45:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[80] = jj_gen;
          break label_45;
        }
        jj_consume_token(S);
      }
      label_46:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[81] = jj_gen;
          break label_46;
        }
        jj_consume_token(COMMA);
        label_47:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[82] = jj_gen;
            break label_47;
          }
          jj_consume_token(S);
        }
        medium();
        label_48:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[83] = jj_gen;
            break label_48;
          }
          jj_consume_token(S);
        }
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void mediaRuleList() throws ParseException {
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LSQUARE:
      case DOT:
      case COLON:
      case ASTERISK:
      case DASH:
      case HASH:
      case IDENT:{
        styleRule();
        break;
        }
      case PAGE_SYM:{
        pageRule();
        break;
        }
      case AT_UNKNOWN:{
        unknownRule();
        break;
        }
      case CHARSET_SYM:{
        charsetRule();
errorUnexpectedRule ("@charset", "charset rule in the middle of a @media rule is not allowed!");
        break;
        }
      case IMPORT_SYM:{
        importRule();
errorUnexpectedRule ("@import", "import rule in the middle of a @media rule is not allowed!");
        break;
        }
      case NAMESPACE_SYM:{
        namespaceRule();
errorUnexpectedRule ("@namespace", "namespace rule in the middle of a @media rule is not allowed!");
        break;
        }
      case MEDIA_SYM:{
        mediaRule();
errorUnexpectedRule ("@media", "media rule in the middle of a @media rule is not allowed!");
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_50:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[85] = jj_gen;
          break label_50;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LSQUARE:
      case DOT:
      case COLON:
      case ASTERISK:
      case DASH:
      case HASH:
      case CHARSET_SYM:
      case IMPORT_SYM:
      case NAMESPACE_SYM:
      case PAGE_SYM:
      case MEDIA_SYM:
      case AT_UNKNOWN:
      case IDENT:{
        ;
        break;
        }
      default:
        jj_la1[86] = jj_gen;
        break label_49;
      }
    }
  }

  final public void mediaRule() throws ParseException {/*@bgen(jjtree) mediaRule */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTMEDIARULE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(MEDIA_SYM);
      label_51:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[87] = jj_gen;
          break label_51;
        }
        jj_consume_token(S);
      }
      mediaList();
      jj_consume_token(LBRACE);
      try {
        label_52:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[88] = jj_gen;
            break label_52;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LSQUARE:
        case DOT:
        case COLON:
        case ASTERISK:
        case DASH:
        case HASH:
        case CHARSET_SYM:
        case IMPORT_SYM:
        case NAMESPACE_SYM:
        case PAGE_SYM:
        case MEDIA_SYM:
        case AT_UNKNOWN:
        case IDENT:{
          mediaRuleList();
          break;
          }
        default:
          jj_la1[89] = jj_gen;
          ;
        }
        jj_consume_token(RBRACE);
      } catch (ParseException ex) {
if (m_bBrowserCompliantMode)
    browserCompliantSkip ();
  else
    errorSkipTo (ex, RBRACE);
      }
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

//
// Page rule
//
  final public void pseudoPage() throws ParseException {/*@bgen(jjtree) pseudoPage */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTPSEUDOPAGE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(COLON);
      jj_consume_token(IDENT);
jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (":" + token.image);
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void pageRule() throws ParseException {/*@bgen(jjtree) pageRule */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTPAGERULE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(PAGE_SYM);
      label_53:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[90] = jj_gen;
          break label_53;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        pseudoPage();
        label_54:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[91] = jj_gen;
            break label_54;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[92] = jj_gen;
        ;
      }
      styleDeclarationBlock();
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

//
// Unknown rule
//
  final public void unknownRuleParameterList() throws ParseException {/*@bgen(jjtree) unknownRuleParameterList */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTUNKNOWNRULEPARAMETERLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String s;
    try {
      s = javaSkipToOpeningBrace();
jjtree.closeNodeScope(jjtn000, true);
                                 jjtc000 = false;
                                 jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (s);
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void unknownRuleBody() throws ParseException {/*@bgen(jjtree) unknownRuleBody */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTUNKNOWNRULEBODY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));String s;
    try {
      s = javaSkipToClosingBrace(1);
jjtree.closeNodeScope(jjtn000, true);
                                  jjtc000 = false;
                                  jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setText (s);
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof ParseEOFException) {
      {if (true) throw (ParseEOFException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

// Any unsupported rule
  final public void unknownRule() throws ParseException {/*@bgen(jjtree) unknownRule */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTUNKNOWNRULE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(AT_UNKNOWN);
jjtn000.setText (token.image);
      unknownRuleParameterList();
      unknownRuleBody();
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
token_source.SwitchTo (DEFAULT);
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

//
// Error handling
// 
  final public void invalid() throws ParseException {/*@bgen(jjtree) invalid */
  com.helger.css.parser.CSSNode jjtn000 = new com.helger.css.parser.CSSNode(JJTINVALID);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case INVALID_STRING1:{
        jj_consume_token(INVALID_STRING1);
        break;
        }
      case INVALID_STRING2:{
        jj_consume_token(INVALID_STRING2);
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_3R_89()
 {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) jj_scanpos = xsp;
    if (jj_scan_token(DASH)) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    Token xsp;
    if (jj_3R_79()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_79()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_67()
 {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(IMPORT_SYM)) return true;
    return false;
  }

  private boolean jj_3R_66()
 {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_65()
 {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_88()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_3R_89()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_58()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_64()
 {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(CHARSET_SYM)) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_60()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    }
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_57()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_58()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_56()
 {
    if (jj_3R_62()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(FUNCTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(4)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_56()) jj_scanpos = xsp;
    if (jj_scan_token(RROUND)) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_100()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) return true;
    }
    return false;
  }

  private boolean jj_3R_94()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_103()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_93()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) return true;
    }
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_scan_token(LSQUARE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(4)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_5()) jj_scanpos = xsp;
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_scan_token(FUNCTION_EXPRESSION)) return true;
    return false;
  }

  private boolean jj_3R_97()
 {
    if (jj_scan_token(FUNCTION)) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) return true;
    }
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_scan_token(URL)) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    if (jj_scan_token(INHERIT)) return true;
    return false;
  }

  private boolean jj_3R_104()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_99()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) return true;
    }
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_62()
 {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    if (jj_scan_token(STRING2)) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    if (jj_scan_token(STRING1)) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_scan_token(HASH)) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) return true;
    }
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_59()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(4)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_57()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(4)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(GREATER)) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_63()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) return true;
    }
    return false;
  }

  private boolean jj_3_8()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(4)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_59()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_3R_92()) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3R_61()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    }
    return false;
  }

  private boolean jj_3R_70()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_scan_token(NAMESPACE_SYM)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ParserCSS21TokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[94];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x22000000,0x22000000,0x10,0x10,0x1000000,0x10,0x10,0x18000,0x0,0x10,0x418000,0x0,0x0,0x0,0x0,0x400000,0x418000,0x10,0x10,0x10,0x10,0x40000000,0x40418000,0x40000000,0x10,0x10,0x10,0x18000,0x10,0x0,0x18000,0x10,0x10,0x0,0x10,0x0,0x0,0x0,0x0,0x18000,0x10,0x0,0x10,0x10,0x10,0x0,0x0,0x10,0x418000,0x0,0x22000000,0x22000000,0x22000000,0x22000000,0x22000000,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x0,0x10,0x0,0x80000000,0x10,0x0,0x10,0x40000000,0x10,0x10,0x10,0x40000000,0x10,0x10,0x22000000,0x10,0x22000000,0x10,0x10,0x22000000,0x10,0x10,0x0,0x60000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x1800,0x27e123,0x27e123,0x1800,0x1800,0x0,0x1800,0x1800,0x0,0x300000,0x0,0xfff00148,0x0,0x48,0xffc00000,0x48,0xffc00000,0xfff00148,0x0,0x0,0x0,0x0,0x14,0xfff0015c,0x14,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x200000,0x0,0x200002,0x200002,0x200002,0x610,0x200000,0x0,0x2,0x0,0x0,0x0,0x610,0x1,0x0,0xfff00148,0x200000,0x101,0x101,0x101,0x101,0x101,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x200000,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x27e123,0x0,0x27e123,0x0,0x0,0x27e123,0x0,0x0,0x1,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x77f,0x600,0x0,0x1f,0x0,0x3f,0x77f,0x0,0x0,0x0,0x0,0x0,0x77f,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x77f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[10];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with user supplied CharStream. */
  public ParserCSS21(CharStream stream) {
    token_source = new ParserCSS21TokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 94; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 94; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ParserCSS21(ParserCSS21TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 94; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ParserCSS21TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 94; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[77];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 94; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 77; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 10; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
