/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.commons.annotation.Nonempty;
import com.helger.css.ECSSVersion;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.ParserCSS30TreeConstants;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ECSSNodeType {
    ROOT(2),
    CHARSET(15),
    UNKNOWNRULE(61),
    UNKNOWNRULEPARAMETERLIST(59),
    UNKNOWNRULEBODY(60),
    STYLERULE(36),
    IMPORTRULE(16),
    PAGERULE(47),
    MEDIARULE(43),
    FONTFACERULE(48),
    SELECTOR(31),
    STYLEDECLARATIONLIST(35),
    STYLEDECLARATION(34),
    NAMESPACEPREFIX(20),
    ELEMENTNAME(21),
    HASH(22),
    CLASS(23),
    PSEUDO(28),
    NEGATION(29),
    ATTRIB(26),
    ATTRIBOPERATOR(24),
    ATTRIBVALUE(25),
    SELECTORCOMBINATOR(30),
    NTH(27),
    PROPERTY(32),
    IMPORTANT(33),
    EXPR(14),
    EXPRTERM(12),
    EXPROPERATOR(13),
    URL(3),
    FUNCTION(4),
    MATH(9),
    MATHSUMOPERATOR(8),
    MATHPRODUCT(7),
    MATHPRODUCTOPERATOR(6),
    MATHUNIT(5),
    LINE_NAMES(11),
    LINE_NAME(10),
    MEDIALIST(42),
    MEDIUM(38),
    MEDIAQUERY(41),
    MEDIAMODIFIER(37),
    MEDIAEXPR(40),
    MEDIAFEATURE(39),
    PSEUDOPAGE(-1),
    PAGESELECTOR(44),
    PAGEMARGINSYMBOL(45),
    PAGERULEBLOCK(46),
    KEYFRAMESRULE(52),
    KEYFRAMESIDENTIFIER(49),
    KEYFRAMESSELECTOR(51),
    SINGLEKEYFRAMESELECTOR(50),
    VIEWPORTRULE(53),
    NAMESPACERULE(19),
    NAMESPACERULEPREFIX(17),
    NAMESPACERULEURL(18),
    SUPPORTSRULE(58),
    SUPPORTSCONDITION(57),
    SUPPORTSCONDITIONOPERATOR(56),
    SUPPORTSNEGATION(55),
    SUPPORTSCONDITIONINPARENS(54),
    ERROR_SKIPTO(1);

    private static final Logger s_aLogger;
    private final int m_nParserType30;

    private ECSSNodeType(int n2) {
        this.m_nParserType30 = n2;
    }

    int getParserNodeType(@Nonnull ECSSVersion eCSSVersion) {
        switch (eCSSVersion) {
            case CSS30: {
                return this.m_nParserType30;
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eCSSVersion));
    }

    public boolean isNode(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        return cSSNode.getNodeType() == this.getParserNodeType(eCSSVersion);
    }

    @Nonnull
    String getNodeName(@Nonnull ECSSVersion eCSSVersion) {
        switch (eCSSVersion) {
            case CSS30: {
                return ParserCSS30TreeConstants.jjtNodeName[this.m_nParserType30];
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eCSSVersion));
    }

    @Nullable
    static ECSSNodeType getNodeType(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        for (ECSSNodeType eCSSNodeType : ECSSNodeType.values()) {
            if (!eCSSNodeType.isNode(cSSNode, eCSSVersion)) continue;
            return eCSSNodeType;
        }
        return null;
    }

    @Nullable
    static String getNodeName(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        ECSSNodeType eCSSNodeType = ECSSNodeType.getNodeType(cSSNode, eCSSVersion);
        if (eCSSNodeType != null) {
            return eCSSNodeType.getNodeName(eCSSVersion);
        }
        s_aLogger.warn("Unsupported node type " + cSSNode.getNodeType() + " in version " + (Object)((Object)eCSSVersion));
        return null;
    }

    private static void _dumpRecursive(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion, @Nonnull StringBuilder stringBuilder, @Nonnull String string) {
        stringBuilder.append(string).append(ECSSNodeType.getNodeName(cSSNode, eCSSVersion));
        if (cSSNode.hasText()) {
            stringBuilder.append('[').append(cSSNode.getText()).append(']');
        }
        stringBuilder.append('\n');
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            ECSSNodeType._dumpRecursive(cSSNode2, eCSSVersion, stringBuilder, string + "  ");
        }
    }

    @Nonnull
    @Nonempty
    public static String getDump(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        StringBuilder stringBuilder = new StringBuilder();
        ECSSNodeType._dumpRecursive(cSSNode, eCSSVersion, stringBuilder, "");
        return stringBuilder.toString();
    }

    public static boolean isErrorNode(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        return ERROR_SKIPTO.isNode(cSSNode, eCSSVersion);
    }

    static {
        s_aLogger = LoggerFactory.getLogger(ECSSNodeType.class);
    }
}

