/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.cache.AbstractNotifyingCache;
import com.helger.commons.datetime.DateTimeFormatterCache;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.datetime.EDTType;
import com.helger.datetime.format.PDTFormatPatterns;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@Immutable
public final class PDTFormatter {
    public static final FormatStyle DEFAULT_STYLE = FormatStyle.MEDIUM;
    private static final LocalizedDateFormatCache s_aParserCache = new LocalizedDateFormatCache();
    private static final PDTFormatter s_aInstance = new PDTFormatter();

    private PDTFormatter() {
    }

    @Nonnull
    public static FormatStyle toFormatStyle(int n) {
        switch (n) {
            case 0: {
                return FormatStyle.FULL;
            }
            case 1: {
                return FormatStyle.LONG;
            }
            case 2: {
                return FormatStyle.MEDIUM;
            }
            case 3: {
                return FormatStyle.SHORT;
            }
        }
        throw new IllegalArgumentException("Invalid style passed: " + n);
    }

    public static int toDateStyle(@Nonnull FormatStyle formatStyle) {
        switch (formatStyle) {
            case FULL: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case MEDIUM: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unsupported style passed: " + (Object)((Object)formatStyle));
    }

    @Nonnull
    public static String getPattern(@Nonnull EDTType eDTType, @Nullable Locale locale, @Nonnull FormatStyle formatStyle, @Nonnull EFormatterMode eFormatterMode) {
        return s_aParserCache.getSourcePattern(new CacheKey(eDTType, locale, formatStyle, eFormatterMode));
    }

    @Nonnull
    public static DateTimeFormatter getWithLocale(@Nonnull DateTimeFormatter dateTimeFormatter, @Nullable Locale locale) {
        DateTimeFormatter dateTimeFormatter2 = dateTimeFormatter;
        if (locale != null) {
            dateTimeFormatter2 = dateTimeFormatter2.withLocale(locale);
        }
        return dateTimeFormatter2;
    }

    @Nonnull
    private static DateTimeFormatter _getFormatter(@Nonnull CacheKey cacheKey, @Nullable Locale locale) {
        DateTimeFormatter dateTimeFormatter = (DateTimeFormatter)s_aParserCache.getFromCache(cacheKey);
        return PDTFormatter.getWithLocale(dateTimeFormatter, locale);
    }

    @Nonnull
    public static DateTimeFormatter getFormatterDate(@Nonnull FormatStyle formatStyle, @Nullable Locale locale, @Nonnull EFormatterMode eFormatterMode) {
        return PDTFormatter._getFormatter(new CacheKey(EDTType.LOCAL_DATE, locale, formatStyle, eFormatterMode), locale);
    }

    @Nonnull
    public static DateTimeFormatter getFormatterTime(@Nonnull FormatStyle formatStyle, @Nullable Locale locale, @Nonnull EFormatterMode eFormatterMode) {
        return PDTFormatter._getFormatter(new CacheKey(EDTType.LOCAL_TIME, locale, formatStyle, eFormatterMode), locale);
    }

    @Nonnull
    public static DateTimeFormatter getFormatterDateTime(@Nonnull FormatStyle formatStyle, @Nullable Locale locale, @Nonnull EFormatterMode eFormatterMode) {
        return PDTFormatter._getFormatter(new CacheKey(EDTType.LOCAL_DATE_TIME, locale, formatStyle, eFormatterMode), locale);
    }

    @Nonnull
    public static DateTimeFormatter getForPattern(@Nonnull String string) throws IllegalArgumentException {
        return PDTFormatter.getForPattern(string, null);
    }

    @Nonnull
    public static DateTimeFormatter getForPattern(@Nonnull String string, @Nullable Locale locale) throws IllegalArgumentException {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatterCache.getDateTimeFormatterStrict((String)string);
        return PDTFormatter.getWithLocale(dateTimeFormatter, locale);
    }

    @ThreadSafe
    private static final class LocalizedDateFormatCache
    extends AbstractNotifyingCache<CacheKey, DateTimeFormatter> {
        public LocalizedDateFormatCache() {
            super(LocalizedDateFormatCache.class.getName());
        }

        @Nonnull
        public String getSourcePattern(@Nonnull CacheKey cacheKey) {
            switch (cacheKey.m_eDTType) {
                case LOCAL_TIME: {
                    return PDTFormatPatterns.getPatternTime(cacheKey.m_eStyle, cacheKey.m_aLocale);
                }
                case LOCAL_DATE: {
                    return PDTFormatPatterns.getPatternDate(cacheKey.m_eStyle, cacheKey.m_aLocale);
                }
            }
            return PDTFormatPatterns.getPatternDateTime(cacheKey.m_eStyle, cacheKey.m_aLocale);
        }

        protected DateTimeFormatter getValueToCache(@Nonnull CacheKey cacheKey) {
            String string = this.getSourcePattern(cacheKey);
            string = StringHelper.replaceAll((String)string, (char)'y', (char)'u');
            if (cacheKey.m_eMode == EFormatterMode.PARSE && "de".equals(cacheKey.m_aLocale.getLanguage()) && cacheKey.m_eStyle == FormatStyle.MEDIUM) {
                string = StringHelper.replaceAll((String)string, (String)"dd", (CharSequence)"d");
                string = StringHelper.replaceAll((String)string, (String)"MM", (CharSequence)"M");
                string = StringHelper.replaceAll((String)string, (String)"HH", (CharSequence)"H");
                string = StringHelper.replaceAll((String)string, (String)"mm", (CharSequence)"m");
                string = StringHelper.replaceAll((String)string, (String)"ss", (CharSequence)"s");
            }
            DateTimeFormatter dateTimeFormatter = DateTimeFormatterCache.getDateTimeFormatterStrict((String)string);
            return dateTimeFormatter;
        }
    }

    @Immutable
    private static final class CacheKey {
        private final EDTType m_eDTType;
        private final Locale m_aLocale;
        private final FormatStyle m_eStyle;
        private final EFormatterMode m_eMode;

        CacheKey(@Nonnull EDTType eDTType, @Nullable Locale locale, @Nonnull FormatStyle formatStyle, @Nonnull EFormatterMode eFormatterMode) {
            ValueEnforcer.notNull((Object)((Object)eDTType), (String)"DTType");
            ValueEnforcer.notNull((Object)((Object)formatStyle), (String)"Style");
            ValueEnforcer.notNull((Object)((Object)eFormatterMode), (String)"Mode");
            this.m_eDTType = eDTType;
            this.m_aLocale = locale != null ? locale : Locale.getDefault(Locale.Category.FORMAT);
            this.m_eStyle = formatStyle;
            this.m_eMode = eFormatterMode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            return this.m_eDTType.equals((Object)cacheKey.m_eDTType) && this.m_aLocale.equals(cacheKey.m_aLocale) && this.m_eStyle.equals((Object)cacheKey.m_eStyle) && this.m_eMode == cacheKey.m_eMode;
        }

        public int hashCode() {
            return new HashCodeGenerator((Object)this).append((Enum)this.m_eDTType).append((Object)this.m_aLocale).append((Enum)this.m_eStyle).append((Enum)this.m_eMode).getHashCode();
        }
    }

    public static enum EFormatterMode {
        PRINT,
        PARSE;

    }
}

