/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.period;

import com.helger.commons.datetime.PDTFactory;
import java.io.Serializable;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ILocalDatePeriod
extends Serializable {
    @Nullable
    public LocalDate getStart();

    default public boolean hasStart() {
        return this.getStart() != null;
    }

    @Nullable
    public LocalDate getEnd();

    default public boolean hasEnd() {
        return this.getEnd() != null;
    }

    default public boolean isInPeriodIncl(@Nonnull LocalDate localDate) {
        LocalDate localDate2 = this.getStart();
        if (localDate2 != null && localDate.compareTo(localDate2) < 0) {
            return false;
        }
        LocalDate localDate3 = this.getEnd();
        return localDate3 == null || localDate.compareTo(localDate3) <= 0;
    }

    default public boolean isNowInPeriodIncl() {
        return this.isInPeriodIncl(PDTFactory.getCurrentLocalDate());
    }

    default public boolean isInPeriodExcl(@Nonnull LocalDate localDate) {
        LocalDate localDate2 = this.getStart();
        if (localDate2 != null && localDate.compareTo(localDate2) <= 0) {
            return false;
        }
        LocalDate localDate3 = this.getEnd();
        return localDate3 == null || localDate.compareTo(localDate3) < 0;
    }

    default public boolean isNowInPeriodExcl() {
        return this.isInPeriodExcl(PDTFactory.getCurrentLocalDate());
    }
}

