/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsIterable;
import com.helger.commons.collection.ext.ICommonsList;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZoneOffset;
import javax.annotation.Nonnull;

public class PDTZoneID
implements Serializable {
    private static ICommonsList<PDTZoneID> s_aZIS = new CommonsArrayList();
    private final String m_sZoneID;
    private final ZoneId m_aZoneID;

    protected PDTZoneID(@Nonnull @Nonempty String string, @Nonnull ZoneId zoneId) {
        this.m_sZoneID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ZoneIDString");
        this.m_aZoneID = (ZoneId)ValueEnforcer.notNull((Object)zoneId, (String)"ZoneID");
    }

    @Nonnull
    @Nonempty
    public String getZoneIDString() {
        return this.m_sZoneID;
    }

    @Nonnull
    public ZoneId getZoneID() {
        return this.m_aZoneID;
    }

    @Nonnull
    public static PDTZoneID of(@Nonnull String string) {
        return new PDTZoneID(string, ZoneId.of(string));
    }

    @Nonnull
    public static PDTZoneID ofHours(@Nonnull String string, int n) {
        return new PDTZoneID(string, ZoneOffset.ofHours(n));
    }

    @Nonnull
    public static ICommonsIterable<PDTZoneID> getDefaultZoneIDs() {
        return s_aZIS;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<PDTZoneID> getAllDefaultZoneIDs() {
        return (ICommonsList)s_aZIS.getClone();
    }

    static {
        s_aZIS.add((Object)PDTZoneID.of("UTC"));
        s_aZIS.add((Object)PDTZoneID.of("GMT"));
        s_aZIS.add((Object)PDTZoneID.ofHours("EST", -5));
        s_aZIS.add((Object)PDTZoneID.ofHours("EDT", -4));
        s_aZIS.add((Object)PDTZoneID.ofHours("CST", -6));
        s_aZIS.add((Object)PDTZoneID.ofHours("CDT", -5));
        s_aZIS.add((Object)PDTZoneID.ofHours("MST", -7));
        s_aZIS.add((Object)PDTZoneID.ofHours("MDT", -6));
        s_aZIS.add((Object)PDTZoneID.ofHours("PST", -8));
        s_aZIS.add((Object)PDTZoneID.ofHours("PDT", -7));
        s_aZIS.add((Object)PDTZoneID.of("UT"));
        s_aZIS.add((Object)PDTZoneID.ofHours("A", -1));
        s_aZIS.add((Object)PDTZoneID.ofHours("B", -2));
        s_aZIS.add((Object)PDTZoneID.ofHours("C", -3));
        s_aZIS.add((Object)PDTZoneID.ofHours("D", -4));
        s_aZIS.add((Object)PDTZoneID.ofHours("E", -5));
        s_aZIS.add((Object)PDTZoneID.ofHours("F", -6));
        s_aZIS.add((Object)PDTZoneID.ofHours("G", -7));
        s_aZIS.add((Object)PDTZoneID.ofHours("H", -8));
        s_aZIS.add((Object)PDTZoneID.ofHours("I", -9));
        s_aZIS.add((Object)PDTZoneID.ofHours("K", -10));
        s_aZIS.add((Object)PDTZoneID.ofHours("L", -11));
        s_aZIS.add((Object)PDTZoneID.ofHours("M", -12));
        s_aZIS.add((Object)PDTZoneID.ofHours("N", 1));
        s_aZIS.add((Object)PDTZoneID.ofHours("O", 2));
        s_aZIS.add((Object)PDTZoneID.ofHours("P", 3));
        s_aZIS.add((Object)PDTZoneID.ofHours("Q", 4));
        s_aZIS.add((Object)PDTZoneID.ofHours("R", 5));
        s_aZIS.add((Object)PDTZoneID.ofHours("S", 6));
        s_aZIS.add((Object)PDTZoneID.ofHours("T", 7));
        s_aZIS.add((Object)PDTZoneID.ofHours("U", 8));
        s_aZIS.add((Object)PDTZoneID.ofHours("V", 9));
        s_aZIS.add((Object)PDTZoneID.ofHours("W", 10));
        s_aZIS.add((Object)PDTZoneID.ofHours("X", 11));
        s_aZIS.add((Object)PDTZoneID.ofHours("Y", 12));
        s_aZIS.add((Object)PDTZoneID.of("Z"));
    }
}

