/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.expiration;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.expiration.IExpirable;
import java.time.LocalDateTime;
import javax.annotation.Nullable;

public final class ReadOnlyExpirable
implements IExpirable {
    private final LocalDateTime m_aExpirationDateTime;

    public ReadOnlyExpirable(@Nullable LocalDateTime localDateTime) {
        this.m_aExpirationDateTime = localDateTime;
    }

    @Override
    public boolean isExpirationDefined() {
        return this.m_aExpirationDateTime != null;
    }

    @Override
    @Nullable
    public LocalDateTime getExpirationDateTime() {
        return this.m_aExpirationDateTime;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ReadOnlyExpirable readOnlyExpirable = (ReadOnlyExpirable)object;
        return EqualsHelper.equals((Object)this.m_aExpirationDateTime, (Object)readOnlyExpirable.m_aExpirationDateTime);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aExpirationDateTime).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("expirationDT", (Object)this.m_aExpirationDateTime).getToString();
    }
}

