/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.expiration;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.expiration.IExpirableWithReplacement;
import java.time.LocalDateTime;
import javax.annotation.Nullable;

public final class ReadOnlyExpirableWithReplacement<DATATYPE>
implements IExpirableWithReplacement<DATATYPE> {
    private final LocalDateTime m_aExpirationDateTime;
    private final DATATYPE m_aReplacement;

    public ReadOnlyExpirableWithReplacement(@Nullable LocalDateTime localDateTime, @Nullable DATATYPE DATATYPE) {
        this.m_aExpirationDateTime = localDateTime;
        this.m_aReplacement = DATATYPE;
    }

    @Override
    public boolean isExpirationDefined() {
        return this.m_aExpirationDateTime != null;
    }

    @Override
    @Nullable
    public LocalDateTime getExpirationDateTime() {
        return this.m_aExpirationDateTime;
    }

    @Override
    @Nullable
    public DATATYPE getReplacement() {
        return this.m_aReplacement;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ReadOnlyExpirableWithReplacement readOnlyExpirableWithReplacement = (ReadOnlyExpirableWithReplacement)object;
        return EqualsHelper.equals((Object)this.m_aExpirationDateTime, (Object)readOnlyExpirableWithReplacement.m_aExpirationDateTime) && EqualsHelper.equals(this.m_aReplacement, readOnlyExpirableWithReplacement.m_aReplacement);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aExpirationDateTime).append(this.m_aReplacement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("expirationDT", (Object)this.m_aExpirationDateTime).append("replacement", this.m_aReplacement).getToString();
    }
}

