/*
 * Decompiled with CFR 0.152.
 */
package com.helger.db.jdbc;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.concurrent.SimpleLock;
import com.helger.commons.string.ToStringGenerator;
import com.helger.db.jdbc.IHasDataSource;
import java.io.Closeable;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractDBConnector
implements IHasDataSource,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDBConnector.class);
    @Nonnull
    private final SimpleLock m_aLock = new SimpleLock();
    protected BasicDataSource m_aDataSource;

    @Nonnull
    protected final SimpleLock getLock() {
        return this.m_aLock;
    }

    @Nonnull
    @Nonempty
    protected abstract String getJDBCDriverClassName();

    @Nonnull
    public abstract String getConnectionUrl();

    @Nullable
    protected abstract String getUserName();

    @Nullable
    protected abstract String getPassword();

    @OverrideOnDemand
    protected boolean isUseDefaultAutoCommit() {
        return false;
    }

    @OverrideOnDemand
    protected boolean isPoolPreparedStatements() {
        return true;
    }

    @Override
    @Nonnull
    public final DataSource getDataSource() {
        return (DataSource)this.m_aLock.lockedGet(() -> {
            BasicDataSource basicDataSource = this.m_aDataSource;
            if (basicDataSource != null && basicDataSource.isClosed()) {
                basicDataSource = null;
            }
            if (basicDataSource == null) {
                String string;
                basicDataSource = new BasicDataSource();
                basicDataSource.setDriverClassName(this.getJDBCDriverClassName());
                String string2 = this.getUserName();
                if (string2 != null) {
                    basicDataSource.setUsername(string2);
                }
                if ((string = this.getPassword()) != null) {
                    basicDataSource.setPassword(string);
                }
                basicDataSource.setUrl(this.getConnectionUrl());
                basicDataSource.setDefaultAutoCommit(Boolean.valueOf(this.isUseDefaultAutoCommit()));
                basicDataSource.setPoolPreparedStatements(this.isPoolPreparedStatements());
                this.m_aDataSource = basicDataSource;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Created new DataSource " + basicDataSource);
                }
            }
            return basicDataSource;
        });
    }

    @Override
    public final void close() {
        try {
            this.m_aLock.lockedThrowing(() -> {
                if (this.m_aDataSource != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Now closing DataSource");
                    }
                    this.m_aDataSource.close();
                    this.m_aDataSource = null;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Closed DataSource");
                    }
                }
            });
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("Failed to close DataSource " + this.m_aDataSource, sQLException);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("DataSource", (Object)this.m_aDataSource).getToString();
    }
}

