/*
 * Decompiled with CFR 0.152.
 */
package com.helger.db.jdbc;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.db.jdbc.IHasConnection;
import com.helger.db.jdbc.IHasDataSource;
import com.helger.db.jdbc.executor.DBNoConnectionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFromDataSource
implements IHasConnection {
    public static final boolean DEFAULT_VALIDITY_CHECK_ENABLED = false;
    public static final int DEFAULT_VALIDITY_CHECK_TIMEOUT_SECONDS = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionFromDataSource.class);
    private final DataSource m_aDS;
    private boolean m_bValidityCheckEnabled = false;
    private int m_nValidityCheckTimeoutSeconds = 3;

    public ConnectionFromDataSource(@Nonnull DataSource dataSource) {
        ValueEnforcer.notNull((Object)dataSource, (String)"DataSource");
        this.m_aDS = dataSource;
    }

    @Nonnull
    protected final DataSource getDataSource() {
        return this.m_aDS;
    }

    public final boolean isValidityCheckEnabled() {
        return this.m_bValidityCheckEnabled;
    }

    @Nonnull
    public final ConnectionFromDataSource setValidityCheckEnabled(boolean bl) {
        this.m_bValidityCheckEnabled = bl;
        return this;
    }

    public final int getValidityCheckTimeoutSeconds() {
        return this.m_nValidityCheckTimeoutSeconds;
    }

    @Nonnull
    public final ConnectionFromDataSource setValidityCheckTimeoutSeconds(int n) {
        this.m_nValidityCheckTimeoutSeconds = Math.min(n, 0);
        return this;
    }

    @Override
    @Nonnull
    public Connection getConnection() throws DBNoConnectionException {
        try {
            Connection connection = this.m_aDS.getConnection();
            if (connection == null) {
                throw new DBNoConnectionException("No connection retrieved from DataSource " + this.m_aDS);
            }
            if (this.m_bValidityCheckEnabled) {
                if (connection.isValid(this.m_nValidityCheckTimeoutSeconds)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("SQL Connection is valid (" + this.m_nValidityCheckTimeoutSeconds + ")");
                    }
                } else {
                    throw new DBNoConnectionException("SQL Connection from DataSource " + this.m_aDS + " is not valid anymore (" + this.m_nValidityCheckTimeoutSeconds + " seconds timeout)");
                }
            }
            return connection;
        }
        catch (SQLException sQLException) {
            throw new DBNoConnectionException("No Connection retrieved from DataSource " + this.m_aDS, sQLException);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("DataSource", (Object)this.m_aDS).append("ValidityCheckEnabled", this.m_bValidityCheckEnabled).append("ValidityCheckTimeoutSeconds", this.m_nValidityCheckTimeoutSeconds).getToString();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public static ConnectionFromDataSource create(@Nonnull IHasDataSource iHasDataSource) {
        ValueEnforcer.notNull((Object)iHasDataSource, (String)"DataSourceProvider");
        return new ConnectionFromDataSource(iHasDataSource.getDataSource());
    }
}

