/*
 * Decompiled with CFR 0.152.
 */
package com.helger.db.jdbc.callback;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.db.jdbc.callback.IGeneratedKeysCallback;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class GetSingleGeneratedKeyCallback
implements IGeneratedKeysCallback {
    private Object m_aGeneratedKey;

    @Override
    public void onGeneratedKeys(@Nonnull ICommonsList<ICommonsList<Object>> iCommonsList) {
        ValueEnforcer.notNull(iCommonsList, (String)"GeneratedValues");
        if (iCommonsList.size() != 1) {
            throw new IllegalArgumentException("Found not exactly 1 generated value row but " + iCommonsList.size() + " rows!");
        }
        ICommonsList iCommonsList2 = (ICommonsList)iCommonsList.getFirst();
        if (iCommonsList2.size() != 1) {
            throw new IllegalArgumentException("The generated row does not contain exactly 1 item but " + iCommonsList2.size() + " items!");
        }
        this.m_aGeneratedKey = iCommonsList2.getFirst();
    }

    @Nonnull
    public Object getGeneratedKey() {
        if (this.m_aGeneratedKey == null) {
            throw new IllegalStateException("No generated key was determined!");
        }
        return this.m_aGeneratedKey;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("generatedKey", this.m_aGeneratedKey).getToString();
    }
}

