/*
 * Decompiled with CFR 0.152.
 */
package com.helger.db.jdbc.executor;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.ICallback;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.callback.exception.LoggingExceptionCallback;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.timing.StopWatch;
import com.helger.commons.wrapper.Wrapper;
import com.helger.db.api.callback.IExecutionTimeExceededCallback;
import com.helger.db.api.callback.LoggingExecutionTimeExceededCallback;
import com.helger.db.api.jdbc.JDBCHelper;
import com.helger.db.jdbc.ConnectionFromDataSource;
import com.helger.db.jdbc.IHasConnection;
import com.helger.db.jdbc.IHasDataSource;
import com.helger.db.jdbc.callback.GetSingleGeneratedKeyCallback;
import com.helger.db.jdbc.callback.IConnectionStatusChangeCallback;
import com.helger.db.jdbc.callback.IGeneratedKeysCallback;
import com.helger.db.jdbc.callback.IPreparedStatementDataProvider;
import com.helger.db.jdbc.callback.IResultSetRowCallback;
import com.helger.db.jdbc.callback.IUpdatedRowCountCallback;
import com.helger.db.jdbc.callback.UpdatedRowCountCallback;
import com.helger.db.jdbc.executor.DBNoConnectionException;
import com.helger.db.jdbc.executor.DBResultField;
import com.helger.db.jdbc.executor.DBResultRow;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DBExecutor
implements Serializable {
    public static final long DEFAULT_EXECUTION_DURATION_WARN_MS = 1000L;
    public static final boolean DEFAULT_DEBUG_CONNECTIONS = false;
    public static final boolean DEFAULT_DEBUG_TRANSACTIONS = false;
    public static final boolean DEFAULT_DEBUG_SQL_STATEMENTS = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(DBExecutor.class);
    private static final AtomicLong COUNTER_CONNECTION = new AtomicLong(0L);
    private static final AtomicLong COUNTER_CONNECTION_OPEN = new AtomicLong(0L);
    private static final AtomicLong COUNTER_CONNECTION_CLOSE = new AtomicLong(0L);
    private static final AtomicLong COUNTER_SQL_STATEMENT = new AtomicLong(0L);
    private static final AtomicLong COUNTER_TRANSACTION = new AtomicLong(0L);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static ETriState s_eConnectionEstablished = ETriState.UNDEFINED;
    @GuardedBy(value="RW_LOCK")
    private static IConnectionStatusChangeCallback s_aConnectionStatusChangeCallback;
    private final IHasConnection m_aConnectionProvider;
    private final CallbackList<IExceptionCallback<? super Exception>> m_aExceptionCallbacks = new CallbackList();
    private IConnectionExecutor m_aConnectionExecutor;
    private long m_nExecutionDurationWarnMS = 1000L;
    private static final CallbackList<IExecutionTimeExceededCallback> EXECUTION_TIME_EXCEEDED_HANDLERS;
    private final AtomicInteger m_aTransactionLevel = new AtomicInteger(0);
    private boolean m_bDebugConnections = false;
    private boolean m_bDebugTransactions = false;
    private boolean m_bDebugSQLStatements = false;

    public DBExecutor(@Nonnull IHasDataSource iHasDataSource) {
        this(ConnectionFromDataSource.create(iHasDataSource));
    }

    public DBExecutor(@Nonnull IHasConnection iHasConnection) {
        ValueEnforcer.notNull((Object)iHasConnection, (String)"ConnectionProvider");
        this.m_aConnectionProvider = iHasConnection;
        this.m_aExceptionCallbacks.add((ICallback)new LoggingExceptionCallback());
        this.m_aConnectionExecutor = this::withNewConnectionDo;
    }

    protected static final void debugLog(@Nonnull String string) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(string);
        }
    }

    @Nonnull
    public static final ETriState getConnectionEstablished() {
        return (ETriState)RW_LOCK.readLockedGet(() -> s_eConnectionEstablished);
    }

    public static final void setConnectionEstablished(@Nonnull ETriState eTriState) {
        Wrapper wrapper;
        EChange eChange;
        ValueEnforcer.notNull((Object)eTriState, (String)"NewState");
        if (eTriState != DBExecutor.getConnectionEstablished() && (eChange = (EChange)RW_LOCK.writeLockedGet(() -> DBExecutor.lambda$setConnectionEstablished$1(wrapper = new Wrapper(), eTriState))).isChanged()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Setting connection established state from " + wrapper.get() + " to " + eTriState);
            }
            RW_LOCK.readLocked(() -> {
                if (s_aConnectionStatusChangeCallback != null) {
                    s_aConnectionStatusChangeCallback.onConnectionStatusChanged((ETriState)wrapper.get(), eTriState);
                }
            });
        }
    }

    public static final void resetConnectionEstablished() {
        DBExecutor.setConnectionEstablished(ETriState.UNDEFINED);
    }

    @Nullable
    public static final IConnectionStatusChangeCallback getConnectionStatusChangeCallback() {
        return (IConnectionStatusChangeCallback)RW_LOCK.readLockedGet(() -> s_aConnectionStatusChangeCallback);
    }

    public static final void setConnectionStatusChangeCallback(@Nullable IConnectionStatusChangeCallback iConnectionStatusChangeCallback) {
        RW_LOCK.writeLockedGet(() -> {
            s_aConnectionStatusChangeCallback = iConnectionStatusChangeCallback;
            return s_aConnectionStatusChangeCallback;
        });
    }

    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IExceptionCallback<? super Exception>> exceptionCallbacks() {
        return this.m_aExceptionCallbacks;
    }

    @CheckForSigned
    public final long getExecutionDurationWarnMS() {
        return this.m_nExecutionDurationWarnMS;
    }

    public final boolean isExecutionDurationWarnEnabled() {
        return this.m_nExecutionDurationWarnMS > 0L;
    }

    @Nonnull
    public final DBExecutor setExecutionDurationWarnMS(long l) {
        this.m_nExecutionDurationWarnMS = l;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public static final CallbackList<IExecutionTimeExceededCallback> executionTimeExceededHandlers() {
        return EXECUTION_TIME_EXCEEDED_HANDLERS;
    }

    public final void onExecutionTimeExceeded(@Nonnull String string, @Nonnegative long l) {
        EXECUTION_TIME_EXCEEDED_HANDLERS.forEach(iExecutionTimeExceededCallback -> iExecutionTimeExceededCallback.onExecutionTimeExceeded(string, l, this.m_nExecutionDurationWarnMS));
    }

    public final boolean isDebugConnections() {
        return this.m_bDebugConnections;
    }

    @Nonnull
    public final DBExecutor setDebugConnections(boolean bl) {
        this.m_bDebugConnections = bl;
        return this;
    }

    public final boolean isDebugTransactions() {
        return this.m_bDebugTransactions;
    }

    @Nonnull
    public final DBExecutor setDebugTransactions(boolean bl) {
        this.m_bDebugTransactions = bl;
        return this;
    }

    public final boolean isDebugSQLStatements() {
        return this.m_bDebugSQLStatements;
    }

    @Nonnull
    public final DBExecutor setDebugSQLStatements(boolean bl) {
        this.m_bDebugSQLStatements = bl;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CodingStyleguideUnaware(value="Needs to be synchronized!")
    protected final ESuccess withNewConnectionDo(@Nonnull IWithConnectionCallback iWithConnectionCallback, @Nullable IExceptionCallback<? super Exception> iExceptionCallback2) {
        long l = COUNTER_CONNECTION.incrementAndGet();
        if (s_eConnectionEstablished.isFalse()) {
            if (this.m_bDebugConnections) {
                DBExecutor.debugLog("Refuse to open SQL Connection [" + l + "] because it failed previously");
            }
            return ESuccess.FAILURE;
        }
        Connection connection = null;
        try {
            if (this.m_bDebugConnections) {
                DBExecutor.debugLog("Opening a new SQL Connection [" + l + "]");
            }
            COUNTER_CONNECTION_OPEN.incrementAndGet();
            connection = this.m_aConnectionProvider.getConnection();
            if (connection == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("  Failed to open SQL Connection [" + l + "]");
                }
                ESuccess eSuccess = ESuccess.FAILURE;
                return eSuccess;
            }
            if (this.m_bDebugConnections) {
                DBExecutor.debugLog("  Opened SQL Connection [" + l + "] is " + connection);
            }
            try {
                if (connection.isClosed()) {
                    throw new DBNoConnectionException("Received a closed connection from provider " + this.m_aConnectionProvider);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            DBExecutor.setConnectionEstablished(ETriState.TRUE);
            ESuccess eSuccess = this.withExistingConnectionDo(connection, iWithConnectionCallback, iExceptionCallback2);
            return eSuccess;
        }
        catch (DBNoConnectionException dBNoConnectionException) {
            DBExecutor.setConnectionEstablished(ETriState.FALSE);
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Connection could not be established. Remembering this status.");
            }
            this.m_aExceptionCallbacks.forEach(iExceptionCallback -> iExceptionCallback.onException((Throwable)dBNoConnectionException));
            if (iExceptionCallback2 != null) {
                iExceptionCallback2.onException((Throwable)dBNoConnectionException);
            }
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            if (connection != null && this.m_aConnectionProvider.shouldCloseConnection()) {
                if (this.m_bDebugConnections) {
                    DBExecutor.debugLog("Now closing SQL Connection [" + l + "] " + connection);
                }
                if (JDBCHelper.close((Connection)connection).isSuccess()) {
                    if (this.m_bDebugConnections) {
                        DBExecutor.debugLog("  Closed SQL Connection [" + l + "] " + connection);
                    }
                } else if (this.m_bDebugConnections) {
                    DBExecutor.debugLog("  Failed to close SQL Connection [" + l + "] " + connection);
                }
                COUNTER_CONNECTION_CLOSE.incrementAndGet();
            }
            if (this.m_bDebugConnections) {
                DBExecutor.debugLog("Opened " + COUNTER_CONNECTION_OPEN.intValue() + " and closed " + COUNTER_CONNECTION_CLOSE.intValue() + " connections");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected final ESuccess withExistingConnectionDo(@Nonnull Connection connection, @Nonnull IWithConnectionCallback iWithConnectionCallback, @Nullable IExceptionCallback<? super Exception> iExceptionCallback2) {
        ValueEnforcer.notNull((Object)connection, (String)"Connection");
        ValueEnforcer.notNull((Object)iWithConnectionCallback, (String)"CB");
        ESuccess eSuccess = ESuccess.FAILURE;
        try {
            iWithConnectionCallback.run(connection);
            eSuccess = JDBCHelper.commit((Connection)connection);
        }
        catch (RuntimeException | SQLException exception) {
            this.m_aExceptionCallbacks.forEach(iExceptionCallback -> iExceptionCallback.onException((Throwable)exception));
            if (iExceptionCallback2 != null) {
                iExceptionCallback2.onException((Throwable)exception);
            }
            ESuccess eSuccess2 = ESuccess.FAILURE;
            return eSuccess2;
        }
        finally {
            if (eSuccess.isFailure()) {
                JDBCHelper.rollback((Connection)connection);
            }
        }
        return eSuccess;
    }

    protected static void handleGeneratedKeys(@Nonnull ResultSet resultSet, @Nonnull IGeneratedKeysCallback iGeneratedKeysCallback) throws SQLException {
        int n = resultSet.getMetaData().getColumnCount();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        while (resultSet.next()) {
            CommonsArrayList commonsArrayList2 = new CommonsArrayList(n);
            for (int i = 1; i <= n; ++i) {
                commonsArrayList2.add(resultSet.getObject(i));
            }
            commonsArrayList.add((Object)commonsArrayList2);
        }
        iGeneratedKeysCallback.onGeneratedKeys((ICommonsList<ICommonsList<Object>>)commonsArrayList);
    }

    @Nonnull
    public final ESuccess performInTransaction(@Nonnull IThrowingRunnable<Exception> iThrowingRunnable) {
        return this.performInTransaction(iThrowingRunnable, null);
    }

    @Nonnull
    public final ESuccess performInTransaction(@Nonnull IThrowingRunnable<Exception> iThrowingRunnable, @Nullable IExceptionCallback<? super Exception> iExceptionCallback) {
        IWithConnectionCallback iWithConnectionCallback = connection -> {
            int n = this.m_aTransactionLevel.incrementAndGet();
            try {
                long l = COUNTER_TRANSACTION.incrementAndGet();
                if (this.m_bDebugTransactions) {
                    DBExecutor.debugLog("Starting a level " + n + " transaction [" + l + "]");
                }
                IConnectionExecutor iConnectionExecutor = this.m_aConnectionExecutor;
                this.m_aConnectionExecutor = (iWithConnectionCallback, iExceptionCallback) -> this.withExistingConnectionDo(connection, iWithConnectionCallback, (IExceptionCallback<? super Exception>)iExceptionCallback);
                try {
                    iThrowingRunnable.run();
                    if (n == 1) {
                        if (this.m_bDebugTransactions) {
                            DBExecutor.debugLog("Now commiting level " + n + " transaction [" + l + "]");
                        }
                        connection.commit();
                    } else if (this.m_bDebugTransactions) {
                        DBExecutor.debugLog("Not commiting level " + n + " transaction [" + l + "] because it is nested");
                    }
                }
                catch (Exception exception) {
                    if (n == 1) {
                        if (this.m_bDebugTransactions) {
                            DBExecutor.debugLog("Now rolling back level " + n + " transaction [" + l + "]: " + exception.getClass().getName() + " - " + exception.getMessage());
                        }
                        connection.rollback();
                    } else if (this.m_bDebugTransactions) {
                        DBExecutor.debugLog("Not rolling back level " + n + " transaction [" + l + "] because it is nested");
                    }
                    if (iExceptionCallback != null) {
                        iExceptionCallback.onException((Throwable)exception);
                    }
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    if (exception instanceof SQLException) {
                        throw (SQLException)exception;
                    }
                    throw new SQLException("Caught exception while perfoming something in a level " + n + " transaction [" + l + "]", exception);
                }
                finally {
                    this.m_aConnectionExecutor = iConnectionExecutor;
                    if (this.m_bDebugTransactions) {
                        DBExecutor.debugLog("Finished level " + n + " transaction [" + l + "]");
                    }
                }
            }
            finally {
                this.m_aTransactionLevel.decrementAndGet();
            }
        };
        return this.m_aConnectionExecutor.execute(iWithConnectionCallback, iExceptionCallback);
    }

    @Nonnull
    protected final ESuccess withStatementDo(@Nonnull IWithStatementCallback iWithStatementCallback, @Nullable IGeneratedKeysCallback iGeneratedKeysCallback, @Nullable IExceptionCallback<? super Exception> iExceptionCallback) {
        IWithConnectionCallback iWithConnectionCallback = connection -> {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                iWithStatementCallback.run(statement);
                if (iGeneratedKeysCallback != null) {
                    DBExecutor.handleGeneratedKeys(statement.getGeneratedKeys(), iGeneratedKeysCallback);
                }
            }
            finally {
                StreamHelper.close((AutoCloseable)statement);
            }
        };
        return this.m_aConnectionExecutor.execute(iWithConnectionCallback, iExceptionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void withTimingDo(@Nonnull String string, @Nonnull IThrowingRunnable<SQLException> iThrowingRunnable) throws SQLException {
        StopWatch stopWatch = StopWatch.createdStarted();
        try {
            iThrowingRunnable.run();
        }
        finally {
            stopWatch.stop();
            long l = stopWatch.getMillis();
            if (this.isExecutionDurationWarnEnabled()) {
                if (l > this.m_nExecutionDurationWarnMS) {
                    this.onExecutionTimeExceeded("DB execution " + string, l);
                }
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("DB execution " + string + " took " + l + " ms");
            }
        }
    }

    @Nonnull
    protected final ESuccess withPreparedStatementDo(@Nonnull String string, @Nonnull IPreparedStatementDataProvider iPreparedStatementDataProvider, @Nonnull IWithPreparedStatementCallback iWithPreparedStatementCallback, @Nullable IUpdatedRowCountCallback iUpdatedRowCountCallback, @Nullable IGeneratedKeysCallback iGeneratedKeysCallback, @Nullable IExceptionCallback<? super Exception> iExceptionCallback) {
        IWithConnectionCallback iWithConnectionCallback = connection -> {
            long l = COUNTER_SQL_STATEMENT.incrementAndGet();
            String string2 = "PreparedStatement [" + l + "] <" + string + "> with " + iPreparedStatementDataProvider.getValueCount() + " values";
            if (this.m_bDebugSQLStatements) {
                DBExecutor.debugLog("Will execute " + string2);
            }
            this.withTimingDo(string2, (IThrowingRunnable<SQLException>)((IThrowingRunnable)() -> {
                try (PreparedStatement preparedStatement = connection.prepareStatement(string, 1);){
                    int n = 1;
                    for (Object e : iPreparedStatementDataProvider.getObjectValues()) {
                        preparedStatement.setObject(n++, e);
                    }
                    iWithPreparedStatementCallback.run(preparedStatement);
                    if (iUpdatedRowCountCallback != null) {
                        try {
                            iUpdatedRowCountCallback.setUpdatedRowCount(preparedStatement.getLargeUpdateCount());
                        }
                        catch (Exception exception) {
                            iUpdatedRowCountCallback.setUpdatedRowCount(preparedStatement.getUpdateCount());
                        }
                    }
                    if (iGeneratedKeysCallback != null) {
                        DBExecutor.handleGeneratedKeys(preparedStatement.getGeneratedKeys(), iGeneratedKeysCallback);
                    }
                }
            }));
        };
        return this.m_aConnectionExecutor.execute(iWithConnectionCallback, iExceptionCallback);
    }

    @Nonnull
    public ESuccess executeStatement(@Nonnull String string) {
        return this.executeStatement(string, null, null);
    }

    @Nonnull
    public ESuccess executeStatement(@Nonnull String string, @Nullable IGeneratedKeysCallback iGeneratedKeysCallback, @Nullable IExceptionCallback<? super Exception> iExceptionCallback) {
        return this.withStatementDo(statement -> {
            long l = COUNTER_SQL_STATEMENT.incrementAndGet();
            String string2 = "Statement [" + l + "] <" + string + ">";
            if (this.m_bDebugSQLStatements) {
                DBExecutor.debugLog("Will execute " + string2);
            }
            this.withTimingDo(string2, (IThrowingRunnable<SQLException>)((IThrowingRunnable)() -> statement.execute(string)));
        }, iGeneratedKeysCallback, iExceptionCallback);
    }

    @Nonnull
    public ESuccess executePreparedStatement(@Nonnull String string, @Nonnull IPreparedStatementDataProvider iPreparedStatementDataProvider) {
        return this.executePreparedStatement(string, iPreparedStatementDataProvider, null, null, null);
    }

    @Nonnull
    public ESuccess executePreparedStatement(@Nonnull String string, @Nonnull IPreparedStatementDataProvider iPreparedStatementDataProvider, @Nullable IUpdatedRowCountCallback iUpdatedRowCountCallback, @Nullable IGeneratedKeysCallback iGeneratedKeysCallback, @Nullable IExceptionCallback<? super Exception> iExceptionCallback) {
        return this.withPreparedStatementDo(string, iPreparedStatementDataProvider, PreparedStatement::execute, iUpdatedRowCountCallback, iGeneratedKeysCallback, iExceptionCallback);
    }

    @Nonnull
    public Object executePreparedStatementAndGetGeneratedKey(@Nonnull String string, @Nonnull IPreparedStatementDataProvider iPreparedStatementDataProvider, @Nullable IExceptionCallback<? super Exception> iExceptionCallback) {
        GetSingleGeneratedKeyCallback getSingleGeneratedKeyCallback = new GetSingleGeneratedKeyCallback();
        if (this.executePreparedStatement(string, iPreparedStatementDataProvider, null, getSingleGeneratedKeyCallback, iExceptionCallback).isFailure()) {
            return null;
        }
        return getSingleGeneratedKeyCallback.getGeneratedKey();
    }

    public long insertOrUpdateOrDelete(@Nonnull String string, @Nonnull IPreparedStatementDataProvider iPreparedStatementDataProvider) {
        return this.insertOrUpdateOrDelete(string, iPreparedStatementDataProvider, null, null);
    }

    public long insertOrUpdateOrDelete(@Nonnull String string, @Nonnull IPreparedStatementDataProvider iPreparedStatementDataProvider, @Nullable IGeneratedKeysCallback iGeneratedKeysCallback, @Nullable IExceptionCallback<? super Exception> iExceptionCallback) {
        UpdatedRowCountCallback updatedRowCountCallback = new UpdatedRowCountCallback();
        this.withPreparedStatementDo(string, iPreparedStatementDataProvider, PreparedStatement::execute, updatedRowCountCallback, iGeneratedKeysCallback, iExceptionCallback);
        return updatedRowCountCallback.getUpdatedRowCount();
    }

    @Nonnull
    public CountAndKey insertOrUpdateAndGetGeneratedKey(@Nonnull String string, @Nonnull IPreparedStatementDataProvider iPreparedStatementDataProvider, @Nullable IExceptionCallback<? super Exception> iExceptionCallback) {
        long l;
        GetSingleGeneratedKeyCallback getSingleGeneratedKeyCallback = new GetSingleGeneratedKeyCallback();
        return new CountAndKey(l, (l = this.insertOrUpdateOrDelete(string, iPreparedStatementDataProvider, getSingleGeneratedKeyCallback, iExceptionCallback)) != -1L ? getSingleGeneratedKeyCallback.getGeneratedKey() : null);
    }

    @Nullable
    private static String _clobToString(@Nullable Clob clob) throws SQLException {
        if (clob == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try (Reader reader = clob.getCharacterStream();
             NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader(reader);){
            int n;
            while ((n = nonBlockingBufferedReader.read()) > -1) {
                stringBuilder.append((char)n);
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Could not convert CLOB to String", iOException);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    protected static final long iterateResultSet(@WillClose ResultSet resultSet, @Nonnull IResultSetRowCallback iResultSetRowCallback) throws SQLException {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n];
            int[] nArray = new int[n];
            for (int i = 1; i <= n; ++i) {
                stringArray[i - 1] = resultSetMetaData.getColumnName(i).intern();
                nArray[i - 1] = resultSetMetaData.getColumnType(i);
            }
            DBResultRow dBResultRow = new DBResultRow(n);
            long l = 0L;
            while (resultSet.next()) {
                ++l;
                dBResultRow.internalClear();
                for (int i = 1; i <= n; ++i) {
                    Object object = resultSet.getObject(i);
                    if (nArray[i - 1] == 2005) {
                        Clob clob = (Clob)object;
                        if (clob.length() <= Integer.MAX_VALUE) {
                            object = DBExecutor._clobToString(clob);
                        } else {
                            LOGGER.warn("The contained CLOB is larger than 2GB (" + clob.length() + " chars) and therefore not converted to a String");
                        }
                    }
                    dBResultRow.internalAdd(new DBResultField(stringArray[i - 1], nArray[i - 1], object));
                }
                iResultSetRowCallback.accept(dBResultRow);
            }
            long l2 = l;
            return l2;
        }
        finally {
            resultSet.close();
        }
    }

    @Nonnull
    public ESuccess queryAll(@Nonnull @Nonempty String string, @Nonnull IResultSetRowCallback iResultSetRowCallback) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SQL");
        ValueEnforcer.notNull((Object)iResultSetRowCallback, (String)"aResultItemCallbackSQL");
        return this.withStatementDo(statement -> {
            long l = COUNTER_SQL_STATEMENT.incrementAndGet();
            String string2 = "Query [" + l + "] <" + string + ">";
            if (this.m_bDebugSQLStatements) {
                DBExecutor.debugLog("Will execute " + string2);
            }
            this.withTimingDo(string2, (IThrowingRunnable<SQLException>)((IThrowingRunnable)() -> {
                ResultSet resultSet = statement.executeQuery(string);
                long l2 = DBExecutor.iterateResultSet(resultSet, iResultSetRowCallback);
                if (this.m_bDebugSQLStatements) {
                    DBExecutor.debugLog("  Found " + l2 + " result rows [" + l + "]");
                }
            }));
        }, null, null);
    }

    @Nonnull
    public ESuccess queryAll(@Nonnull String string, @Nonnull IPreparedStatementDataProvider iPreparedStatementDataProvider, @Nonnull IResultSetRowCallback iResultSetRowCallback) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SQL");
        ValueEnforcer.notNull((Object)iPreparedStatementDataProvider, (String)"PreparedStatementDataProvider");
        ValueEnforcer.notNull((Object)iResultSetRowCallback, (String)"aResultItemCallbackSQL");
        return this.withPreparedStatementDo(string, iPreparedStatementDataProvider, preparedStatement -> {
            ResultSet resultSet = preparedStatement.executeQuery();
            long l = DBExecutor.iterateResultSet(resultSet, iResultSetRowCallback);
            if (this.m_bDebugSQLStatements) {
                DBExecutor.debugLog("  Found " + l + " result rows");
            }
        }, null, null, null);
    }

    @Nullable
    public ICommonsList<DBResultRow> queryAll(@Nonnull @Nonempty String string) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (this.queryAll(string, arg_0 -> DBExecutor.lambda$queryAll$18((ICommonsList)commonsArrayList, arg_0)).isFailure()) {
            return null;
        }
        return commonsArrayList;
    }

    @Nullable
    public ICommonsList<DBResultRow> queryAll(@Nonnull @Nonempty String string, @Nonnull IPreparedStatementDataProvider iPreparedStatementDataProvider) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (this.queryAll(string, iPreparedStatementDataProvider, arg_0 -> DBExecutor.lambda$queryAll$19((ICommonsList)commonsArrayList, arg_0)).isFailure()) {
            return null;
        }
        return commonsArrayList;
    }

    @Nonnull
    public ESuccess querySingle(@Nonnull @Nonempty String string, @Nonnull Consumer<? super DBResultRow> consumer) {
        ICommonsList<DBResultRow> iCommonsList = this.queryAll(string);
        if (iCommonsList == null) {
            return ESuccess.FAILURE;
        }
        if (iCommonsList.size() > 1) {
            LOGGER.warn("The query '" + string + "' returned " + iCommonsList.size() + " results but only the first one is used.");
        }
        consumer.accept((DBResultRow)iCommonsList.getFirst());
        return ESuccess.SUCCESS;
    }

    @Nonnull
    public ESuccess querySingle(@Nonnull @Nonempty String string, @Nonnull IPreparedStatementDataProvider iPreparedStatementDataProvider, @Nonnull Consumer<? super DBResultRow> consumer) {
        ICommonsList<DBResultRow> iCommonsList = this.queryAll(string, iPreparedStatementDataProvider);
        if (iCommonsList == null) {
            return ESuccess.FAILURE;
        }
        if (iCommonsList.size() > 1) {
            LOGGER.warn("The query '" + string + "' returned " + iCommonsList.size() + " results but only the first one is used.");
        }
        consumer.accept((DBResultRow)iCommonsList.getFirst());
        return ESuccess.SUCCESS;
    }

    @CheckForSigned
    public long queryCount(@Nonnull String string) {
        Wrapper wrapper = new Wrapper();
        this.querySingle(string, arg_0 -> ((Wrapper)wrapper).set(arg_0));
        return wrapper.isNotSet() ? -1L : ((Number)((DBResultRow)wrapper.get()).getValue(0)).longValue();
    }

    @CheckForSigned
    public long queryCount(@Nonnull String string, @Nonnull IPreparedStatementDataProvider iPreparedStatementDataProvider) {
        Wrapper wrapper = new Wrapper();
        this.querySingle(string, iPreparedStatementDataProvider, arg_0 -> ((Wrapper)wrapper).set(arg_0));
        return wrapper.isNotSet() ? -1L : ((Number)((DBResultRow)wrapper.get()).getValue(0)).longValue();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ConnectionProvider", (Object)this.m_aConnectionProvider).append("ExceptionCalbacks", this.m_aExceptionCallbacks).append("ConnectionExecutor", (Object)this.m_aConnectionExecutor).append("ExecutionDurationWarnMS", this.m_nExecutionDurationWarnMS).append("TransactionLevel", (Object)this.m_aTransactionLevel).append("DebugConnections", this.m_bDebugConnections).append("DebugTransactions", this.m_bDebugTransactions).append("DebugSQLStatements", this.m_bDebugSQLStatements).getToString();
    }

    private static /* synthetic */ void lambda$queryAll$19(ICommonsList iCommonsList, DBResultRow dBResultRow) {
        if (dBResultRow != null) {
            iCommonsList.add((Object)dBResultRow.getClone());
        }
    }

    private static /* synthetic */ void lambda$queryAll$18(ICommonsList iCommonsList, DBResultRow dBResultRow) {
        if (dBResultRow != null) {
            iCommonsList.add((Object)dBResultRow.getClone());
        }
    }

    private static /* synthetic */ EChange lambda$setConnectionEstablished$1(Wrapper wrapper, ETriState eTriState) {
        wrapper.set((Object)s_eConnectionEstablished);
        if (eTriState == wrapper.get()) {
            return EChange.UNCHANGED;
        }
        s_eConnectionEstablished = eTriState;
        return EChange.CHANGED;
    }

    static {
        EXECUTION_TIME_EXCEEDED_HANDLERS = new CallbackList();
        EXECUTION_TIME_EXCEEDED_HANDLERS.add((ICallback)new LoggingExecutionTimeExceededCallback(true));
    }

    public static final class CountAndKey {
        private final long m_nUpdateCount;
        private final Object m_aGeneratedKey;

        public CountAndKey(@Nonnegative long l, @Nullable Object object) {
            this.m_nUpdateCount = l;
            this.m_aGeneratedKey = object;
        }

        @Nonnegative
        public long getUpdateCount() {
            return this.m_nUpdateCount;
        }

        public boolean isUpdateCountUsable() {
            return this.m_nUpdateCount != -1L;
        }

        @Nullable
        public Object getGeneratedKey() {
            return this.m_aGeneratedKey;
        }

        public boolean hasGeneratedKey() {
            return this.m_aGeneratedKey != null;
        }
    }

    @FunctionalInterface
    private static interface IConnectionExecutor {
        @Nonnull
        public ESuccess execute(@Nonnull IWithConnectionCallback var1, @Nullable IExceptionCallback<? super Exception> var2);
    }

    @FunctionalInterface
    private static interface IWithPreparedStatementCallback
    extends ICallback {
        public void run(@Nonnull PreparedStatement var1) throws SQLException;
    }

    @FunctionalInterface
    private static interface IWithStatementCallback
    extends ICallback {
        public void run(@Nonnull Statement var1) throws SQLException;
    }

    @FunctionalInterface
    private static interface IWithConnectionCallback
    extends ICallback {
        public void run(@Nonnull Connection var1) throws SQLException;
    }
}

